<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Currency_model extends CI_Model
{
    //set selected currency
    public function set_selected_currency()
    {
        $currency_code = $this->input->post('currency', true);
        $currency = $this->get_currency_by_code($currency_code);
        if (!empty($currency)) {
            $this->session->set_userdata('mds_selected_currency', $currency->code);
        }
    }

    //get selected currency
    public function get_selected_currency($default_currency)
    {
        if ($this->payment_settings->currency_converter == 1 && !empty($this->session->userdata('mds_selected_currency'))) {
            if (isset($this->currencies[$this->session->userdata('mds_selected_currency')])) {
                return $this->currencies[$this->session->userdata('mds_selected_currency')];
            }
        }
        return $this->default_currency;
    }

    //get default currency
    public function get_default_currency($currencies, $payment_settings)
    {
        if (isset($currencies[$payment_settings->default_currency])) {
            return $currencies[$payment_settings->default_currency];
        }
        $currencies = $this->get_currencies();
        return @$currencies[0];
    }

    //add currency
    public function add_currency()
    {
        $data = array(
            'code' => $this->input->post('code', true),
            'name' => $this->input->post('name', true),
            'symbol' => $this->input->post('symbol', true),
            'currency_format' => $this->input->post('currency_format', true),
            'symbol_direction' => $this->input->post('symbol_direction', true),
            'space_money_symbol' => $this->input->post('space_money_symbol', true),
            'status' => $this->input->post('status', true)
        );

        return $this->db->insert('currencies', $data);
    }

    //update currency
    public function update_currency($id)
    {
        $id = clean_number($id);
        $data = array(
            'code' => $this->input->post('code', true),
            'name' => $this->input->post('name', true),
            'symbol' => $this->input->post('symbol', true),
            'currency_format' => $this->input->post('currency_format', true),
            'symbol_direction' => $this->input->post('symbol_direction', true),
            'space_money_symbol' => $this->input->post('space_money_symbol', true),
            'status' => $this->input->post('status', true)
        );

        $this->db->where('id', $id);
        return $this->db->update('currencies', $data);
    }

    //get currencies array
    public function get_currencies_array()
    {
        $currencies = $this->db->order_by('status DESC, id')->get('currencies')->result();
        $array = array();
        if (!empty($currencies)) {
            foreach ($currencies as $currency) {
                $array[$currency->code] = $currency;
            }
        }
        return $array;
    }

    //get currencies
    public function get_currencies()
    {
        $this->db->order_by('status DESC, id');
        return $this->db->get('currencies')->result();
    }

    //get currency
    public function get_currency($id)
    {
        $this->db->where('id', clean_number($id));
        return $this->db->get('currencies')->row();
    }

    //get currency by code
    public function get_currency_by_code($code)
    {
        return $this->db->where('code', clean_str($code))->get('currencies')->row();
    }

    //update currency settings
    public function update_currency_settings()
    {
        $data = array(
            'default_currency' => $this->input->post('default_currency', true),
            'allow_all_currencies_for_classied' => $this->input->post('allow_all_currencies_for_classied', true)
        );

        $this->db->where('id', 1);
        $this->db->update('payment_settings', $data);
        $this->update_currency_rates($data['default_currency'], null);
        return true;
    }

    //update currency converter settings
    public function update_currency_converter_settings()
    {
        $data = array(
            'currency_converter' => $this->input->post('currency_converter', true),
            'auto_update_exchange_rates' => $this->input->post('auto_update_exchange_rates', true),
            'currency_converter_api' => $this->input->post('currency_converter_api', true),
            'currency_converter_api_key' => $this->input->post('currency_converter_api_key', true)
        );
        $this->db->where('id', 1);
        $this->db->update('payment_settings', $data);
        $this->update_currency_rates(null, $data['currency_converter_api'], $data['currency_converter_api_key']);
        return true;
    }

    //update currency rates
    public function update_currency_rates($base = null, $service = null, $service_key = null)
    {
        if (empty($base)) {
            $base = $this->payment_settings->default_currency;
        }
        if (empty($service)) {
            $service = $this->payment_settings->currency_converter_api;
        }
        if (empty($service_key)) {
            $service_key = $this->payment_settings->currency_converter_api_key;
        }
        if ($this->payment_settings->currency_converter == 1) {
            $this->load->library('currency');
            $this->currency->updateExchangeRates($base, $service, $service_key);
        }
        return true;
    }

    //edit currency rate
    public function edit_currency_rate()
    {
        $currency_id = $this->input->post('currency_id', true);
        $exchange_rate = $this->input->post('exchange_rate', true);
        $currency = $this->get_currency($currency_id);
        if (!empty($currency)) {
            $this->db->where('id', $currency->id);
            $this->db->update('currencies', ['exchange_rate' => $exchange_rate]);
        }
    }

    //delete currency
    public function delete_currency($id)
    {
        $id = clean_number($id);
        $currency = $this->get_currency($id);
        if (!empty($currency)) {
            $this->db->where('id', $id);
            return $this->db->delete('currencies');
        }
        return false;
    }

}