<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if(isset($page->meta_tag) && isset($page->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($page->meta_tag); ?>">
        <meta name="description" content="<?php echo e($page->meta_description); ?>"> 
    <?php elseif(isset($blog->meta_tag) && isset($blog->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($blog->meta_tag); ?>">
        <meta name="description" content="<?php echo e($blog->meta_description); ?>"> 
    <?php else: ?>
        <meta name="keywords" content="<?php echo e($seo->meta_keys); ?>">
    <?php endif; ?>
    <meta name="author" content="GeniusOcean">
    <title><?php echo e($gs->title); ?></title>
    <!-- Font Awesome CSS -->
<style type="text/css">
    @import  url('https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900|Rubik:300,400,500,700,900');
</style>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/all.css')); ?>">

    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>"> 

    <?php echo $__env->make('styles.design', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?> 

    <?php echo $__env->yieldContent('styles'); ?>

    <style type="text/css">
        .home-service-wrapper {
            box-shadow: 0 0 5px #fff;
        }
    </style>

</head>
<body>
    <?php if($gs->is_loader == 1): ?>
    <div id="cover"></div>
    <?php endif; ?>
<?php if($gs->is_subscribe == 1): ?>
<?php if(isset($visited)): ?>
    <div style="display:none">
        <img src="<?php echo e(asset('assets/images/'.$gs->subscribe_image)); ?>">
    </div>
    <!--  Starting of subscribe-pre-loader Area   -->
    <div class="subscribe-preloader-wrap" id="subscriptionForm" style="display: none;">
        <div class="subscribePreloader__thumb" style="background-image: url(<?php echo e(asset('assets/images/'.$gs->subscribe_image)); ?>);">
            <span class="preload-close"><i class="fa fa-close"></i></span>
            <div class="subscribePreloader__text text-center">
                <h1><?php echo e($gs->subscribe_title); ?></h1>
                <p><?php echo e($gs->subscribe_text); ?></p>
                <form action="<?php echo e(route('front.subscribe.submit')); ?>" method="POST">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <input type="email" name="email" id="" placeholder="<?php echo e($lang->supl); ?>" required="">
                        <button type="submit"><?php echo e($lang->s); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--  Ending of subscribe-pre-loader Area   -->

<?php endif; ?>
<?php endif; ?>
    <!--  Starting of header area   -->
    <header class="header-wrap">
        <div class="header-support-part">
            <div class="header-top-area">
                <div class="container">
    <?php if($lang->rtl == 1): ?>

                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="header-top-right-wrap text-left">
                                <ul>
                                    <?php if($ps->is_currency == 1): ?>
                                    <li><a style="cursor: pointer;">
                                    <?php if(Session::has('currency')): ?> 
                                    <?php 
                                    $cur_name = App\Currency::findOrFail(Session::get('currency'));
                                     ?>
                                        <?php echo e($cur_name->sign); ?> <?php echo e($cur_name->name); ?>

                                    <?php else: ?>
                                    <?php 
                                    $cur_name = App\Currency::where('is_default','=',1)->first();
                                     ?>
                                        <?php echo e($cur_name->sign); ?> <?php echo e($cur_name->name); ?>

                                    <?php endif; ?>
                                    <i class="fa fa-angle-down"></i></a>
                                        <ul style="box-shadow: none;">
                                            <?php 
                                            $cur_names = App\Currency::all();
                                             ?>
                                            <?php $__currentLoopData = $cur_names; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li style="width: 100%"><a style="display: block; border-left: none; float: right; padding: 0 15px;" href="<?php echo e(route('front.curr',$cn->id)); ?>">
                                                <?php echo e($cn->name); ?></a>
                                             </li>                                           
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <?php if($gs->is_language == 1): ?>
                                    <li class="language"><a style="cursor: pointer;"><i class="fa fa-globe"></i>
                                    <?php if(Session::has('language')): ?> 
                                    <?php 
                                    $langlang = App\Language::findOrFail(Session::get('language'));
                                     ?>
                                        <?php echo e($langlang->language); ?>

                                    <?php else: ?>
                                    <?php 
                                    $langlang = App\Language::findOrFail(1);
                                     ?>
                                        <?php echo e($langlang->language); ?>

                                    <?php endif; ?>
                                    <i class="fa fa-angle-down"></i></a>
                                        <ul style="box-shadow: none;">
                                            <?php 
                                            $languages = App\Language::all();
                                             ?>
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ln): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li style="width: 100%"><a style="display: block; float: right;; padding: 0 15px;" href="<?php echo e(route('front.lang',$ln->id)); ?>">
                                                <?php echo e($ln->language); ?></a>
                                             </li>                                           
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="header-top-left-wrap">
                                <ul>
                                    <?php if($gs->email != null): ?>
                                    <li id="front-top-mail"><a style="padding-right: 0;"><i class="fa fa-envelope"></i> <?php echo e($gs->email); ?></a></li>
                                    <?php endif; ?>
                                    <?php if($gs->phone != null): ?>
                                    <li><a><i class="fa fa-phone"></i> <?php echo e($gs->phone); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>


     <?php else: ?>

                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="header-top-left-wrap">
                                <ul>
                                    <?php if($gs->email != null): ?>
                                    <li id="front-top-mail"><a style="padding-left: 0;"><i class="fa fa-envelope"></i> <?php echo e($gs->email); ?></a></li>
                                    <?php endif; ?>
                                    <?php if($gs->phone != null): ?>
                                    <li><a><i class="fa fa-phone"></i> <?php echo e($gs->phone); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                            <div class="header-top-right-wrap text-right">
                                <ul>
                                    <?php if($ps->is_currency == 1): ?>
                                    <li><a style="cursor: pointer;">
                                    <?php if(Session::has('currency')): ?> 
                                    <?php 
                                    $cur_name = App\Currency::findOrFail(Session::get('currency'));
                                     ?>
                                        <?php echo e($cur_name->sign); ?> <?php echo e($cur_name->name); ?>

                                    <?php else: ?>
                                    <?php 
                                    $cur_name = App\Currency::where('is_default','=',1)->first();
                                     ?>
                                        <?php echo e($cur_name->sign); ?> <?php echo e($cur_name->name); ?>

                                    <?php endif; ?>
                                    <i class="fa fa-angle-down"></i></a>
                                        <ul style="box-shadow: none;">
                                            <?php 
                                            $cur_names = App\Currency::all();
                                             ?>
                                            <?php $__currentLoopData = $cur_names; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li style="display: block;"><a style="display: block; border-right: none;" href="<?php echo e(route('front.curr',$cn->id)); ?>">
                                                <?php echo e($cn->name); ?></a>
                                             </li>                                           
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>

                                    <?php if($gs->is_language == 1): ?>
                                    <li class="language"><a style="cursor: pointer;"><i class="fa fa-globe"></i>
                                    <?php if(Session::has('language')): ?> 
                                    <?php 
                                    $langlang = App\Language::findOrFail(Session::get('language'));
                                     ?>
                                        <?php echo e($langlang->language); ?>

                                    <?php else: ?>
                                    <?php 
                                    $langlang = App\Language::findOrFail(1);
                                     ?>
                                        <?php echo e($langlang->language); ?>

                                    <?php endif; ?>
                                    <i class="fa fa-angle-down"></i></a>
                                        <ul style="box-shadow: none;">
                                            <?php 
                                            $languages = App\Language::all();
                                             ?>
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ln): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <li><a style="display: block;" href="<?php echo e(route('front.lang',$ln->id)); ?>">
                                                <?php echo e($ln->language); ?></a>
                                             </li>                                           
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>

    <?php endif; ?>
                </div>
            </div>
            <div class="header-middle-area">
                <div class="container">
                    <div class="row">

    <?php if($lang->rtl == 1): ?>
                        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
                            <div class="header-middle-right-wrap text-left">
                                <ul>
                                <li>
                                <?php if(Auth::guard('user')->check()): ?>
                                    <a href="<?php echo e(route('user-wishlists')); ?>"><span><?php echo e($lang->wishlists); ?></span> <i class="fa fa-heart"></i></a>
                                <?php else: ?>
                                    <a style="cursor: pointer;" class="no-wish" data-toggle="modal" data-target="#loginModal"><span><?php echo e($lang->wishlists); ?></span> <i class="fa fa-heart"></i></a>
                                <?php endif; ?>
                                </li>
                                    <li>
                                        <?php if(Auth::guard('user')->check()): ?>
                                            <a style="text-transform: uppercase" href="<?php echo e(route('user-dashboard')); ?>">
                                                <i class="fa fa-user"></i> <span><?php echo e($lang->fh); ?></span>
                                            </a>
                                        <?php else: ?>
                                            <a style="text-transform: uppercase" href="<?php echo e(route('user-login')); ?>">
                                                <i class="fa fa-user"></i> <span><?php echo e($lang->signinup); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </li>
                                    <li class="myCart"><a href="javascript:void(0)"> <i class="fa fa-cart-plus"></i></a> <span class="cart-quantity"><?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?></span>
                                        <div class="addToMycart">
                                            <div class="cart">
                                            <?php if(Session::has('cart')): ?>
                                            <?php $__currentLoopData = Session::get('cart')->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="single-myCart">
                                                <p class="cart-close" onclick="remove(<?php echo e($product['item']['id']); ?>)"><i class="fa fa-close"></i></p>
                                                <div class="cart-img">
                                                    <img src="<?php echo e(asset('assets/images/'.$product['item']['photo'])); ?>" alt="Product image">
                                                </div>
                                                <div class="cart-info">
                                                    <a href="<?php echo e(route('front.product',[$product['item']['id'],$product['item']['name']])); ?>" style="color: black; padding: 0 0;"><h5><?php echo e(strlen($product['item']['name']) > 45 ? substr($product['item']['name'],0,45).'...' : $product['item']['name']); ?></h5></a>
                                                <p><?php echo e($lang->cquantity); ?>: <span id="cqt<?php echo e($product['item']['id']); ?>"><?php echo e($product['qty']); ?></span> <span><?php echo e($product['item']['measure']); ?></span></p>
                                                <p>
                                                <?php if($gs->sign == 0): ?>
                                                    <?php echo e($curr->sign); ?><span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span>
                                                <?php else: ?>
                                                    <span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                                </p>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>                                            
                                            </div>
                                            <h5 class="empty"><?php echo e(Session::has('cart') ? '' :$lang->h); ?></h5>
                                            <hr/>
                                            <h4 class="text-left"><?php echo e($lang->vt); ?>

                                            <?php if($gs->sign == 0): ?>                                                   
                                             <?php echo e($curr->sign); ?><span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span>
                                            <?php else: ?>
                                             <span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span><?php echo e($curr->sign); ?>

                                            <?php endif; ?>
                                         </h4>
                                            <div class="addMyCart-btns">
                                                <a href="<?php echo e(route('front.cart')); ?>" class="black-btn"><?php echo e($lang->vdn); ?></a>
                                                <a href="<?php echo e(route('front.checkout')); ?>" class="black-btn"><?php echo e($lang->gt); ?></a>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="myCart1"><a href="javascript:void(0)"> <i class="fa fa-cart-plus"></i></a> <span class="cart-quantity"><?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?></span>
                                        <div class="addToMycart1">
                                            <div class="cart">
                                            <?php if(Session::has('cart')): ?>
                                            <?php $__currentLoopData = Session::get('cart')->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="single-myCart">
                                                <p class="cart-close" onclick="remove(<?php echo e($product['item']['id']); ?>)"><i class="fa fa-close"></i></p>
                                                <div class="cart-img">
                                                    <img src="<?php echo e(asset('assets/images/'.$product['item']['photo'])); ?>" alt="Product image">
                                                </div>
                                                <div class="cart-info">
                                                    <a href="<?php echo e(route('front.product',[$product['item']['id'],$product['item']['name']])); ?>" style="color: black; padding: 0 0;"><h5><?php echo e(strlen($product['item']['name']) > 45 ? substr($product['item']['name'],0,45).'...' : $product['item']['name']); ?></h5></a>
                                                <p><?php echo e($lang->cquantity); ?>: <span id="cqt<?php echo e($product['item']['id']); ?>"><?php echo e($product['qty']); ?></span> <span><?php echo e($product['item']['measure']); ?></span></p>
                                                <p>
                                                <?php if($gs->sign == 0): ?>
                                                    <?php echo e($curr->sign); ?><span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span>
                                                <?php else: ?>
                                                    <span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                                </p>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>                                            
                                            </div>
                                            <h5 class="empty"><?php echo e(Session::has('cart') ? '' :$lang->h); ?></h5>
                                            <hr/>
                                            <h4 class="text-left"><?php echo e($lang->vt); ?> 
                                                <?php if($gs->sign == 0): ?>
                                                <?php echo e($curr->sign); ?><span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span>
                                                <?php else: ?>
                                                <span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                            </h4>
                                            <div class="addMyCart-btns">
                                                <a href="<?php echo e(route('front.cart')); ?>" class="black-btn"><?php echo e($lang->vdn); ?></a>
                                                <a href="<?php echo e(route('front.checkout')); ?>" class="black-btn"><?php echo e($lang->gt); ?></a>
                                            </div>
                                        </div>
                                    </li>

                                    <li class="circle-li"><a href="<?php echo e(route('front.compare')); ?>"><i class="fa fa-exchange"></i></a> <span class="compare-quantity"><?php echo e(Session::has('compare') ? count(Session::get('compare')->items) : '0'); ?></span>
                                    </li>
                        <?php if($gs->reg_vendor == 1): ?>
                                    <li class="sell-btn">
            <?php if(Auth::guard('user')->check()): ?>
            <a href="<?php echo e(route('user-dashboard')); ?>"><?php echo e($lang->sale); ?></a>
            <?php else: ?>
            <a style="cursor: pointer;" data-toggle="modal" data-target="#vendorloginModal"><?php echo e($lang->sale); ?></a>
            <?php endif; ?>
                                    </li>
                        <?php endif; ?>
                                    <li class="mobile-search"><a href="javascript:void(0)"><i class="fa fa-search"></i></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
                            <div class="header-middle-left-wrap">
                                <div class="logo">
                                    <a href="<?php echo e(route('front.index')); ?>">
                                    <img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" alt="Logo">
                                    </a>
                                    <?php if($gs->reg_vendor == 1): ?>
                                    <span class="sell-btn">
            <?php if(Auth::guard('user')->check()): ?>
            <a href="<?php echo e(route('user-dashboard')); ?>"><?php echo e($lang->sale); ?></a>
            <?php else: ?>
            <a style="cursor: pointer;" data-toggle="modal" data-target="#vendorloginModal"><?php echo e($lang->sale); ?></a>
            <?php endif; ?>
                                    </span>
            <?php endif; ?>
                                </div>
                            </div>
                        </div>
    <?php else: ?>
                        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
                            <div class="header-middle-left-wrap">
                                <div class="logo">
                                    <a href="<?php echo e(route('front.index')); ?>">
                                    <img src="<?php echo e(asset('assets/images/'.$gs->logo)); ?>" alt="Logo">
                                    </a>
                                    <?php if($gs->reg_vendor == 1): ?>
                                    <span class="sell-btn">
            <?php if(Auth::guard('user')->check()): ?>
            <a href="<?php echo e(route('user-dashboard')); ?>"><?php echo e($lang->sale); ?></a>
            <?php else: ?>
            <a style="cursor: pointer;" data-toggle="modal" data-target="#vendorloginModal"><?php echo e($lang->sale); ?></a>
            <?php endif; ?>
                                    </span>
            <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
                            <div class="header-middle-right-wrap text-right">
                                <ul>
                                <li>
                                <?php if(Auth::guard('user')->check()): ?>
                                    <a href="<?php echo e(route('user-wishlists')); ?>"><i class="fa fa-heart"></i> <span><?php echo e($lang->wishlists); ?></span></a>
                                <?php else: ?>
                                    <a style="cursor: pointer;" class="no-wish" data-toggle="modal" data-target="#loginModal"><i class="fa fa-heart"></i> <span><?php echo e($lang->wishlists); ?></span></a>
                                <?php endif; ?>
                                </li>
                                    <li>
                                        <?php if(Auth::guard('user')->check()): ?>
                                            <a style="text-transform: uppercase" href="<?php echo e(route('user-dashboard')); ?>">
                                                <i class="fa fa-user"></i> <span><?php echo e($lang->fh); ?></span>
                                            </a>
                                        <?php else: ?>
                                            <a style="text-transform: uppercase" href="<?php echo e(route('user-login')); ?>">
                                                <i class="fa fa-user"></i> <span><?php echo e($lang->signinup); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </li>




                                    <li class="myCart"><a href="javascript:void(0)"> <i class="fa fa-cart-plus"></i></a> <span class="cart-quantity"><?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?></span>
                                        <div class="addToMycart">
                                            <div class="cart">
                                            <?php if(Session::has('cart')): ?>
                                            <?php $__currentLoopData = Session::get('cart')->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="single-myCart">
                                                <p class="cart-close" onclick="remove(<?php echo e($product['item']['id']); ?>)"><i class="fa fa-close"></i></p>
                                                <div class="cart-img">
                                                    <img src="<?php echo e(asset('assets/images/'.$product['item']['photo'])); ?>" alt="Product image">
                                                </div>
                                                <div class="cart-info">
                                                    <a href="<?php echo e(route('front.product',[$product['item']['id'],$product['item']['name']])); ?>" style="color: black; padding: 0 0;"><h5><?php echo e(strlen($product['item']['name']) > 45 ? substr($product['item']['name'],0,45).'...' : $product['item']['name']); ?></h5></a>
                                                <p><?php echo e($lang->cquantity); ?>: <span id="cqt<?php echo e($product['item']['id']); ?>"><?php echo e($product['qty']); ?></span> <span><?php echo e($product['item']['measure']); ?></span></p>
                                                <p>
                                                <?php if($gs->sign == 0): ?>
                                                    <?php echo e($curr->sign); ?><span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span>
                                                <?php else: ?>
                                                    <span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                                </p>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>                                            
                                            </div>
                                            <h5 class="empty"><?php echo e(Session::has('cart') ? '' :$lang->h); ?></h5>
                                            <hr/>
                                            <h4 class="text-right"><?php echo e($lang->vt); ?>

                                            <?php if($gs->sign == 0): ?>                                                   
                                             <?php echo e($curr->sign); ?><span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span>
                                            <?php else: ?>
                                             <span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span><?php echo e($curr->sign); ?>

                                            <?php endif; ?>
                                         </h4>
                                            <div class="addMyCart-btns">
                                                <a href="<?php echo e(route('front.cart')); ?>" class="black-btn"><?php echo e($lang->vdn); ?></a>
                                                <a href="<?php echo e(route('front.checkout')); ?>" class="black-btn"><?php echo e($lang->gt); ?></a>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="myCart1"><a href="javascript:void(0)"> <i class="fa fa-cart-plus"></i></a> <span class="cart-quantity"><?php echo e(Session::has('cart') ? count(Session::get('cart')->items) : '0'); ?></span>
                                        <div class="addToMycart1">
                                            <div class="cart">
                                            <?php if(Session::has('cart')): ?>
                                            <?php $__currentLoopData = Session::get('cart')->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="single-myCart">
                                                <p class="cart-close" onclick="remove(<?php echo e($product['item']['id']); ?>)"><i class="fa fa-close"></i></p>
                                                <div class="cart-img">
                                                    <img src="<?php echo e(asset('assets/images/'.$product['item']['photo'])); ?>" alt="Product image">
                                                </div>
                                                <div class="cart-info">
                                                    <a href="<?php echo e(route('front.product',[$product['item']['id'],$product['item']['name']])); ?>" style="color: black; padding: 0 0;"><h5><?php echo e(strlen($product['item']['name']) > 45 ? substr($product['item']['name'],0,45).'...' : $product['item']['name']); ?></h5></a>
                                                <p><?php echo e($lang->cquantity); ?>: <span id="cqt<?php echo e($product['item']['id']); ?>"><?php echo e($product['qty']); ?></span> <span><?php echo e($product['item']['measure']); ?></span></p>
                                                <p>
                                                <?php if($gs->sign == 0): ?>
                                                    <?php echo e($curr->sign); ?><span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span>
                                                <?php else: ?>
                                                    <span id="prct<?php echo e($product['item']['id']); ?>"><?php echo e(round($product['price'] * $curr->value , 2)); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                                </p>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>                                            
                                            </div>
                                            <h5 class="empty"><?php echo e(Session::has('cart') ? '' :$lang->h); ?></h5>
                                            <hr/>
                                            <h4 class="text-right"><?php echo e($lang->vt); ?> 
                                                <?php if($gs->sign == 0): ?>
                                                <?php echo e($curr->sign); ?><span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span>
                                                <?php else: ?>
                                                <span class="total"><?php echo e(Session::has('cart') ? round(Session::get('cart')->totalPrice * $curr->value , 2) : '0.00'); ?></span><?php echo e($curr->sign); ?>

                                                <?php endif; ?>
                                            </h4>
                                            <div class="addMyCart-btns">
                                                <a href="<?php echo e(route('front.cart')); ?>" class="black-btn"><?php echo e($lang->vdn); ?></a>
                                                <a href="<?php echo e(route('front.checkout')); ?>" class="black-btn"><?php echo e($lang->gt); ?></a>
                                            </div>
                                        </div>
                                    </li>

                                    <li class="circle-li"><a href="<?php echo e(route('front.compare')); ?>"><i class="fa fa-exchange"></i></a> <span class="compare-quantity"><?php echo e(Session::has('compare') ? count(Session::get('compare')->items) : '0'); ?></span>
                                    </li>
                        <?php if($gs->reg_vendor == 1): ?>
                                    <li class="sell-btn">
            <?php if(Auth::guard('user')->check()): ?>
            <a href="<?php echo e(route('user-dashboard')); ?>"><?php echo e($lang->sale); ?></a>
            <?php else: ?>
            <a style="cursor: pointer;" data-toggle="modal" data-target="#vendorloginModal"><?php echo e($lang->sale); ?></a>
            <?php endif; ?>
                                    </li>
                        <?php endif; ?>
                                    <li class="mobile-search"><a href="javascript:void(0)"><i class="fa fa-search"></i></a></li>
                                </ul>
                            </div>
                        </div>
    <?php endif; ?>


                        <div class="col-lg-12">
                            <div class="header-search-box mobile">
                                    <div class="search-close">
                                    <i class="fa fa-times"></i>
                                </div>
                                <form action="<?php echo e(route('front.search')); ?>" method="GET">
                                    <input type="text" class="ss" id="search_product" name="product" placeholder="<?php echo e($lang->ec); ?>" required>
                                    <button type="submit"><i class="fa fa-search"></i></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="header-bottom-area">
            <div class="container">
                <div class="row">
        <?php if($lang->rtl == 1): ?>
                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-2">
                        <div class="header-search-box text-left">
                            <form action="<?php echo e(route('front.search')); ?>" method="GET">
                                <button type="submit"><i class="fa fa-search"></i></button>
                                <input type="text" class="ss" id="header_search" name="product" placeholder="<?php echo e($lang->ec); ?>" required>
                            </form>
                        </div>
                        <div class="header-searched-item-list-wrap" style="display: none;">
                            <ul>

                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-5">
                        <div class="header-menu-wrap">
                            <ul>
                                <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e($lang->home); ?></a></li>
                                <li><a href="<?php echo e(route('front.blog')); ?>"><?php echo e($lang->blog); ?></a></li>
                                <?php if($ps->f_status == 1): ?>
                                <li><a href="<?php echo e(route('front.faq')); ?>"><?php echo e($lang->faq); ?></a></li>
                                <?php endif; ?>
                                <?php if($ps->c_status == 1): ?>
                                <li><a href="<?php echo e(route('front.contact')); ?>"><?php echo e($lang->contact); ?></a></li>
                                <?php endif; ?>
                                <?php if(count($pages) > 0): ?>
                    <li><a style="cursor: pointer;"><?php echo e($lang->others); ?> <i class="fa fa-angle-down"></i></a>
                                    <ul>
                                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e(route('front.page',$pg->slug)); ?>"><?php echo e(strtoupper($pg->title)); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="mobileSlickMenuActive"></div>
                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-5">
                        <div class="header-bottom-left-wrap">
                        <h5><i class="fa fa-angle-down"></i> <?php echo e($lang->all_categories); ?> <i class="fa fa-bars"></i></h5>
                            <ul>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('front.category',$category->cat_slug)); ?>">
                                    <?php if($category->photo != null): ?>
                                    <img src="<?php echo e(asset('assets/images/'.$category->photo)); ?>" alt="">
                                    <?php else: ?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <?php endif; ?>
                                    <?php echo e($category->cat_name); ?> <i class="<?php echo e(count($category->subs) > 0 ? 'fa fa-angle-left':''); ?>"></i>
                                </a>
                                    <?php if(count($category->subs) > 0): ?>
                                    <ul>
                                        <li><?php echo e($category->cat_name); ?></li> 
                <?php $__currentLoopData = $category->subs()->where('status','=',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                                   
                                        <li><a href="<?php echo e(route('front.subcategory',$subcategory->sub_slug)); ?>"><?php echo e($subcategory->sub_name); ?> <i class="<?php echo e(count($subcategory->childs) > 0 ? 'fa fa-angle-left' : ''); ?>"></i></a>
                                        <?php if(count($subcategory->childs) > 0): ?>
                                            <ul>
                                                <li><?php echo e($subcategory->sub_name); ?></li>
                    <?php $__currentLoopData = $subcategory->childs()->where('status','=',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route('front.childcategory',$childcategory->child_slug)); ?>"><?php echo e($childcategory->child_name); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    

                                            </ul>
                                        <?php endif; ?>
                                        </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                    <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="mobileMenuActive"></div>
        <?php else: ?>
                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-5">
                        <div class="header-bottom-left-wrap">
                        <h5><i class="fa fa-bars"></i> <?php echo e($lang->all_categories); ?> <i class="fa fa-angle-down"></i></h5>
                            <ul>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('front.category',$category->cat_slug)); ?>">
                                    <?php if($category->photo != null): ?>
                                    <img src="<?php echo e(asset('assets/images/'.$category->photo)); ?>" alt="">
                                    <?php else: ?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <?php endif; ?>
                                    <?php echo e($category->cat_name); ?> <i class="<?php echo e(count($category->subs) > 0 ? 'fa fa-angle-right':''); ?>"></i>
                                </a>
                                    <?php if(count($category->subs) > 0): ?>
                                    <ul>
                                        <li><?php echo e($category->cat_name); ?></li> 
                <?php $__currentLoopData = $category->subs()->where('status','=',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                                   
                                        <li><a href="<?php echo e(route('front.subcategory',$subcategory->sub_slug)); ?>"><?php echo e($subcategory->sub_name); ?> <i class="<?php echo e(count($subcategory->childs) > 0 ? 'fa fa-angle-right' : ''); ?>"></i></a>
                                        <?php if(count($subcategory->childs) > 0): ?>
                                            <ul>
                                                <li><?php echo e($subcategory->sub_name); ?></li>
                    <?php $__currentLoopData = $subcategory->childs()->where('status','=',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route('front.childcategory',$childcategory->child_slug)); ?>"><?php echo e($childcategory->child_name); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    

                                            </ul>
                                        <?php endif; ?>
                                        </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                    <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="mobileMenuActive"></div>
                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-5">
                        <div class="header-menu-wrap">
                            <ul>
                                <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e($lang->home); ?></a></li>
                                <li><a href="<?php echo e(route('front.blog')); ?>"><?php echo e($lang->blog); ?></a></li>
                                <?php if($ps->f_status == 1): ?>
                                <li><a href="<?php echo e(route('front.faq')); ?>"><?php echo e($lang->faq); ?></a></li>
                                <?php endif; ?>
                                <?php if($ps->c_status == 1): ?>
                                <li><a href="<?php echo e(route('front.contact')); ?>"><?php echo e($lang->contact); ?></a></li>
                                <?php endif; ?>
                                <?php if(count($pages) > 0): ?>
                    <li><a style="cursor: pointer;"><?php echo e($lang->others); ?> <i class="fa fa-angle-down"></i></a>
                                    <ul>
                                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e(route('front.page',$pg->slug)); ?>"><?php echo e(strtoupper($pg->title)); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>

                    </div>

                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-2">
                        <div class="header-search-box text-right">
                            <form action="<?php echo e(route('front.search')); ?>" method="GET">
                                <input type="text" class="ss" id="header_search" name="product" placeholder="<?php echo e($lang->ec); ?>" required>
                                <button type="submit"><i class="fa fa-search"></i></button>
                            </form>
                        </div>
                        <div class="header-searched-item-list-wrap" style="display: none;">
                            <ul>

                            </ul>
                        </div>
                    </div>
                    <div class="mobileSlickMenuActive"></div>
        <?php endif; ?>

                </div>
            </div>
        </div>
    </header>
            <?php 
            $i=1;
            $j=1;
             ?>

    <!--  Ending of header area   -->
        <?php echo $__env->yieldContent('content'); ?>



    <!-- Starting of footer area -->
    <footer class="footer-wrap">
        <div class="subscribe-newsletter-wrap">
            <div class="container">
                <div class="row">
                    <?php if($lang->rtl == 1): ?>
                    <div class="col-lg-10 col-lg-offset-1 col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1">
                        <div class="subscribe-newsletter-text-area">
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-7 col-xs-8">
                                    <div class="subscribe-form">
                                        <form action="<?php echo e(route('front.subscribe.submit')); ?>" method="POST">
                                            <?php echo e(csrf_field()); ?>

                                            <button type="submit" class="subscribe-btn"><?php echo e($lang->s); ?></button> 
                                            <input type="email" name="email" id="subscribe_email" placeholder="<?php echo e($lang->supl); ?>" required> 
                                        </form>                                
                                    </div>
                                </div>
                                <div class="col-lg-4 col-lg-offset-1 col-md-4 col-md-offset-1 col-sm-5 col-xs-4">
                                    <h4><?php echo e($lang->ston); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-lg-10 col-lg-offset-1 col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1">
                        <div class="subscribe-newsletter-text-area">
                            <div class="row">
                                <div class="col-lg-4 col-lg-offset-1 col-md-4 col-md-offset-1 col-sm-5">
                                    <h4><?php echo e($lang->ston); ?></h4>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-7">
                                    <div class="subscribe-form">
                                        <form action="<?php echo e(route('front.subscribe.submit')); ?>" method="POST">
                                            <?php echo e(csrf_field()); ?>

                                            <input type="email" name="email" id="subscribe_email" placeholder="<?php echo e($lang->supl); ?>" required>
                                            <button type="submit" class="subscribe-btn"><?php echo e($lang->s); ?></button>  
                                        </form>                                
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="footer-top-wrap" style="background-image: url(<?php echo e(asset('assets/images/'.$gs->footer_background)); ?>)">
            <div class="container">
                <div class="row">
                    <?php if($lang->rtl == 1): ?>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="single-footer-wrap contact">
                            <h4 class="footer-title text-right"><?php echo e($lang->contact); ?></h4>
                            <ul>
                            <?php if($gs->street != null): ?>    
                                <li><a><i class="fa fa-map-marker" aria-hidden="true"></i>
                                    <span><?php echo e($gs->street); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->phone != null): ?> 
                                <li><a href="tel:<?php echo e($gs->phone); ?>"><i class="fa fa-phone" aria-hidden="true"></i>
                                    <span><?php echo e($gs->phone); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->email != null): ?>
                            <li><a href="mailto:<?php echo e($gs->email); ?>"><i class="fa fa-envelope" aria-hidden="true"></i>
                                    <span><?php echo e($gs->email); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->site != null): ?>
                                <li><a href="<?php echo e($gs->site); ?>"><i class="fa fa-globe" aria-hidden="true"></i>
                                    <span><?php echo e($gs->site); ?></span>
                                </a></li>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="single-footer-wrap">
                            <h4 class="footer-title text-right"><?php echo e($lang->lns); ?></h4>
                            <ul>
                            <?php $__currentLoopData = $lblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lblog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <img height="30" width="31" src="<?php echo e(asset('assets/images/'.$lblog->photo)); ?>" alt="footer image">
                                    <span><a href="<?php echo e(route('front.blogshow',$lblog->id)); ?>"><?php echo e(strlen($lblog->title) > 30 ? substr($lblog->title,0,30)."..." : $lblog->title); ?></a></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="single-footer-wrap information">
                            <h4 class="footer-title text-right"><?php echo e($lang->fl); ?></h4>
                            <ul>
                                    <li><a href="<?php echo e(route('front.index')); ?>"><i class="fa fa-angle-double-left"></i> &nbsp;<?php echo e($lang->home); ?></a></li>
                                <?php if($ps->f_status == 1): ?>
                                    <li><a href="<?php echo e(route('front.faq')); ?>"><i class="fa fa-angle-double-left"></i> &nbsp;<?php echo e($lang->faq); ?></a></li>
                                <?php endif; ?>
                                <?php if($ps->c_status == 1): ?>
                                    <li><a href="<?php echo e(route('front.contact')); ?>"><i class="fa fa-angle-double-left"></i> &nbsp;<?php echo e($lang->contact); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="single-footer-wrap">
                            <h4 class="footer-title text-right"><?php echo e($lang->about); ?></h4>
                            <p dir="rtl">
                                <?php echo e($gs->about); ?>

                            </p>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="col-lg-3 col-md-3 col-sm-6">
                        <div class="single-footer-wrap">
                            <h4 class="footer-title"><?php echo e($lang->about); ?></h4>
                            <p>
                                <?php echo e($gs->about); ?>

                            </p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6">
                        <div class="single-footer-wrap information">
                            <h4 class="footer-title"><?php echo e($lang->fl); ?></h4>
                            <ul>
                                    <li><a href="<?php echo e(route('front.index')); ?>"><i class="fa fa-angle-double-right"></i> &nbsp;<?php echo e($lang->home); ?></a></li>
                                <?php if($ps->f_status == 1): ?>
                                    <li><a href="<?php echo e(route('front.faq')); ?>"><i class="fa fa-angle-double-right"></i> &nbsp;<?php echo e($lang->faq); ?></a></li>
                                <?php endif; ?>
                                <?php if($ps->c_status == 1): ?>
                                    <li><a href="<?php echo e(route('front.contact')); ?>"><i class="fa fa-angle-double-right"></i> &nbsp;<?php echo e($lang->contact); ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6">
                        <div class="single-footer-wrap">
                            <h4 class="footer-title"><?php echo e($lang->lns); ?></h4>
                            <ul>
                            <?php $__currentLoopData = $lblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lblog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <img height="30" width="31" src="<?php echo e(asset('assets/images/'.$lblog->photo)); ?>" alt="footer image">
                                    <span><a href="<?php echo e(route('front.blogshow',$lblog->id)); ?>"><?php echo e(strlen($lblog->title) > 30 ? substr($lblog->title,0,30)."..." : $lblog->title); ?></a></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6">
                        <div class="single-footer-wrap contact">
                            <h4 class="footer-title"><?php echo e($lang->contact); ?></h4>
                            <ul>
                            <?php if($gs->street != null): ?>    
                                <li><a><i class="fa fa-map-marker" aria-hidden="true"></i>
                                    <span><?php echo e($gs->street); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->phone != null): ?> 
                                <li><a href="tel:<?php echo e($gs->phone); ?>"><i class="fa fa-phone" aria-hidden="true"></i>
                                    <span><?php echo e($gs->phone); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->email != null): ?>
                            <li><a href="mailto:<?php echo e($gs->email); ?>"><i class="fa fa-envelope" aria-hidden="true"></i>
                                    <span><?php echo e($gs->email); ?></span>
                                </a></li>
                            <?php endif; ?>
                            <?php if($gs->site != null): ?>
                                <li><a href="<?php echo e($gs->site); ?>"><i class="fa fa-globe" aria-hidden="true"></i>
                                    <span><?php echo e($gs->site); ?></span>
                                </a></li>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="footer-bottom-wrap">
            <div class="container">
                <div class="row">
                    <?php if($lang->rtl == 1): ?>
                    <div class="col-lg-6 col-md-6 col-sm-5 col-xs-12">
                        <div class="footer-social-links">
                            <ul>
                            <?php if($sl->f_status == 1): ?>
                            <li><a class="facebook" href="<?php echo e($sl->facebook); ?>">
                                <i class="fa fa-facebook"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->g_status == 1): ?>
                            <li><a class="google" href="<?php echo e($sl->gplus); ?>">
                                <i class="fa fa-google"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->t_status == 1): ?>
                            <li><a class="twitter" href="<?php echo e($sl->twitter); ?>">
                                <i class="fa fa-twitter"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->l_status == 1): ?>
                            <li><a class="tumblr" href="<?php echo e($sl->linkedin); ?>">
                                <i class="fa fa-linkedin"></i>
                            </a></li>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-7 col-xs-12">
                        <div class="footer-copyright-area">
                            <?php echo $gs->footer; ?>

                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-lg-6 col-md-6 col-sm-7 col-xs-12">
                        <div class="footer-copyright-area">
                            <?php echo $gs->footer; ?>

                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-5 col-xs-12">
                        <div class="footer-social-links">
                            <ul>
                            <?php if($sl->f_status == 1): ?>
                            <li><a class="facebook" href="<?php echo e($sl->facebook); ?>">
                                <i class="fa fa-facebook"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->g_status == 1): ?>
                            <li><a class="google" href="<?php echo e($sl->gplus); ?>">
                                <i class="fa fa-google"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->t_status == 1): ?>
                            <li><a class="twitter" href="<?php echo e($sl->twitter); ?>">
                                <i class="fa fa-twitter"></i>
                            </a></li>
                            <?php endif; ?>
                            <?php if($sl->l_status == 1): ?>
                            <li><a class="tumblr" href="<?php echo e($sl->linkedin); ?>">
                                <i class="fa fa-linkedin"></i>
                            </a></li>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>
    <!-- Ending of footer area -->

    <!-- Starting of Product View Modal -->
    <div class="modal fade" id="myModal" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">

        </div>
    </div>
  </div>
  <!-- Ending of Product View Modal -->

    <!-- Starting of Product View Modal -->
    <div class="modal fade" id="loginModal" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header" style="margin-right:10px;">
            <button type="button" class="close" data-dismiss="modal">&times;</button>

          </div>

          <div class="modal-body">
              <div class="row" style="margin: 15px;">
          <div class="login-tab">
            <ul class="nav nav-tabs">
              <li class="active"><a data-toggle="tab" href="#login1"><?php echo e($lang->signin); ?></a></li>
              <li><a data-toggle="tab" href="#signup1"><?php echo e($lang->signup); ?></a></li>
            </ul>
            
            <div class="tab-content">
              <div id="login1" class="tab-pane fade in active">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->signin); ?></h3>
                </div>

                <div class="login-form">
                  <form action="<?php echo e(route('user-login-submit')); ?>" method="POST">
                              <?php echo e(csrf_field()); ?>


                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_email1"><?php echo e($lang->doeml); ?></label>
            <input type="email" name="email" class="form-control" id="login_email1" placeholder="<?php echo e($lang->doeml); ?>" required>
                    </div>
                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_pwd1"><?php echo e($lang->sup); ?></label>
<input type="password" name="password" class="form-control" id="login_pwd1" placeholder="<?php echo e($lang->sup); ?>" required>
                    </div>
                    <input type="hidden" name="wish" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->sie); ?></button>
                    <?php if($sl->fcheck == 1  || $sl->gcheck == 1): ?>
                    <div class="login-social-btn-area">

                        <?php if($sl->fcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','facebook')); ?>" class="social-btn"><i class="fa fa-facebook"></i> <span><?php echo e($lang->facebook_login); ?></span></a>
                        <?php endif; ?>
                        <?php if($sl->gcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','google')); ?>" class="social-btn last-child"><i class="fa fa-google"></i> <span><?php echo e($lang->google_login); ?></span></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                  </form>

                </div>

              </div>
              <div id="signup1" class="tab-pane fade">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->signup); ?></h3>
                </div>
                  <?php echo $__env->make('includes.form-error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <div class="login-form">
                  <form action="<?php echo e(route('user-register-submit')); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>


                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_email1"><?php echo e($lang->doeml); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doeml); ?>" type="email" name="email" id="reg_email1" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_name1"><?php echo e($lang->fname); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->fname); ?>" type="text" name="name" id="reg_name1" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Pnumber1"><?php echo e($lang->doph); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doph); ?>" type="text" name="phone" id="reg_Pnumber1" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Padd1"><?php echo e($lang->doad); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doad); ?>" type="text" name="address" id="reg_Padd1" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_password1"><?php echo e($lang->sup); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sup); ?>" type="password" name="password" id="reg_password1" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="confirm_password1"><?php echo e($lang->sucp); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sucp); ?>" type="password" name="password_confirmation" id="confirm_password1" required>
                      </div>
                    <input type="hidden" name="wish" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->spe); ?></button>
                  </form>
                </div>
              </div>
            </div>
          </div>    
  
              </div>
          </div>
        </div>
    </div>
  </div>


    <!-- Starting of Product View Modal -->
    <div class="modal fade" id="vendorloginModal" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header" style="margin-right:10px;">
            <button type="button" class="close" data-dismiss="modal">&times;</button>

          </div>

          <div class="modal-body">
              <div class="row" style="margin: 15px;">
          <div class="login-tab">
            <ul class="nav nav-tabs">
              <li class="active"><a data-toggle="tab" href="#login111"><?php echo e($lang->signin); ?></a></li>
              <li><a data-toggle="tab" href="#signup111"><?php echo e($lang->vendor_registration); ?></a></li>
            </ul>
            
            <div class="tab-content">
              <div id="login111" class="tab-pane fade in active">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->signin); ?></h3>
                </div>

                <div class="login-form">
                  <form action="<?php echo e(route('user-login-submit')); ?>" method="POST">
                              <?php echo e(csrf_field()); ?>


                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_email11"><?php echo e($lang->doeml); ?></label>
            <input type="email" name="email" class="form-control" id="login_email11" placeholder="<?php echo e($lang->doeml); ?>" required>
                    </div>
                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_pwd11"><?php echo e($lang->sup); ?></label>
<input type="password" name="password" class="form-control" id="login_pwd11" placeholder="<?php echo e($lang->sup); ?>" required>
                    </div>
                    <input type="hidden" name="package" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->sie); ?></button>
                    <?php if($sl->fcheck == 1  || $sl->gcheck == 1): ?>
                    <div class="login-social-btn-area">

                        <?php if($sl->fcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','facebook')); ?>" class="social-btn"><i class="fa fa-facebook"></i> <span><?php echo e($lang->facebook_login); ?></span></a>
                        <?php endif; ?>
                        <?php if($sl->gcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','google')); ?>" class="social-btn last-child"><i class="fa fa-google"></i> <span><?php echo e($lang->google_login); ?></span></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                  </form>

                </div>

              </div>
              <div id="signup111" class="tab-pane fade">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->vendor_registration); ?></h3>
                </div>
                  <?php echo $__env->make('includes.form-error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <div class="login-form">
                  <form action="<?php echo e(route('vendor.registration')); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>

                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_email11"><?php echo e($lang->doeml); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doeml); ?>" type="email" name="email" id="reg_email11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_name11"><?php echo e($lang->fname); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->fname); ?>" type="text" name="name" id="reg_name11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Pnumber11"><?php echo e($lang->doph); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doph); ?>" type="text" name="phone" id="reg_Pnumber11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Padd11"><?php echo e($lang->doad); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doad); ?>" type="text" name="address" id="reg_Padd11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_password11"><?php echo e($lang->sup); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sup); ?>" type="password" name="password" id="reg_password11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="confirm_password11"><?php echo e($lang->sucp); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sucp); ?>" type="password" name="password_confirmation" id="confirm_password11" required>
                      </div>
                    <input type="hidden" name="wish" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->spe); ?></button>
                  </form>
                </div>
              </div>
            </div>
          </div>    
  
              </div>
          </div>
        </div>
    </div>
  </div>

<?php if(isset($checked)): ?>
    <!-- Starting of Product View Modal -->
    <div class="modal fade" id="checkoutModal"  data-keyboard="false" data-backdrop="static" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header" style="margin-right:10px;">
            <a href="<?php echo e(url()->previous()); ?>" class="close">&times;</a>

          </div>

          <div class="modal-body">
              <div class="row" style="margin: 15px;">
          <div class="login-tab">
            <ul class="nav nav-tabs">
              <li class="active"><a data-toggle="tab" href="#login11"><?php echo e($lang->signin); ?></a></li>
              <li><a data-toggle="tab" href="#signup11"><?php echo e($lang->signup); ?></a></li>
            </ul>
            
            <div class="tab-content">
              <div id="login11" class="tab-pane fade in active">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->signin); ?></h3>
                </div>
      <div class="alert alert-danger validation">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            <p class="text-center"><?php echo e($lang->digital_login); ?></p> 
      </div>
                <div class="login-form">
                  <form action="<?php echo e(route('user-login-submit')); ?>" method="POST">
                              <?php echo e(csrf_field()); ?>


                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_email11"><?php echo e($lang->doeml); ?></label>
            <input type="email" name="email" class="form-control" id="login_email11" placeholder="<?php echo e($lang->doeml); ?>" required>
                    </div>
                    <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                      <label for="login_pwd11"><?php echo e($lang->sup); ?></label>
<input type="password" name="password" class="form-control" id="login_pwd11" placeholder="<?php echo e($lang->sup); ?>" required>
                    </div>
                    <input type="hidden" name="wish" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->sie); ?></button>
                    <?php if($sl->fcheck == 1  || $sl->gcheck == 1): ?>
                    <div class="login-social-btn-area">

                        <?php if($sl->fcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','facebook')); ?>" class="social-btn"><i class="fa fa-facebook"></i> <span><?php echo e($lang->facebook_login); ?></span></a>
                        <?php endif; ?>
                        <?php if($sl->gcheck ==1): ?>
                      <a href="<?php echo e(route('social-provider','google')); ?>" class="social-btn last-child"><i class="fa fa-google"></i> <span><?php echo e($lang->google_login); ?></span></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                  </form>

                </div>

              </div>
              <div id="signup11" class="tab-pane fade">
                <div class="login-title text-center">
                  <h3><?php echo e($lang->signup); ?></h3>
                </div>
                  <?php echo $__env->make('includes.form-error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <div class="login-form">
                  <form action="<?php echo e(route('user-register-submit')); ?>" method="POST">
                      <?php echo e(csrf_field()); ?>


                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_email11"><?php echo e($lang->doeml); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doeml); ?>" type="email" name="email" id="reg_email11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_name11"><?php echo e($lang->fname); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->fname); ?>" type="text" name="name" id="reg_name11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Pnumber11"><?php echo e($lang->doph); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doph); ?>" type="text" name="phone" id="reg_Pnumber11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_Padd11"><?php echo e($lang->doad); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->doad); ?>" type="text" name="address" id="reg_Padd11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="reg_password11"><?php echo e($lang->sup); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sup); ?>" type="password" name="password" id="reg_password11" required>
                      </div>
                      <div class="form-group <?php echo e($lang->rtl == 1 ? 'text-right' : ''); ?>">
                          <label for="confirm_password11"><?php echo e($lang->sucp); ?> <span>*</span></label>
                          <input class="form-control" placeholder="<?php echo e($lang->sucp); ?>" type="password" name="password_confirmation" id="confirm_password11" required>
                      </div>
                    <input type="hidden" name="wish" value="1">
                    <button type="submit" class="btn btn-default btn-block"><?php echo e($lang->spe); ?></button>
                  </form>
                </div>
              </div>
            </div>
          </div>    
  
              </div>
          </div>
        </div>
    </div>
  </div>


<?php endif; ?>
                    <?php if(isset($vendor)): ?>
          <?php if(Auth::guard('user')->check()): ?>
    <!-- Starting of Product email Modal -->
    <div class="modal vendor" id="emailModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" <?php echo $lang->rtl == 1 ? 'style="float: left;"':''; ?>><span aria-hidden="true"><i class="ti-close"></i></span></button>
            <h4 class="modal-title" id="myModalLabel" <?php echo $lang->rtl == 1 ? 'dir="rtl"':''; ?>><?php echo e($lang->new_message); ?></h4>
          </div>
          <form id="emailreply"  method="POST">
            <?php echo e(csrf_field()); ?>

          <div class="modal-body">
                <div class="form-group">
                    <input type="text" class="form-control" readonly="" value="<?php echo e($lang->send_to); ?> <?php echo e($vendor->shop_name); ?>">
                </div>
                <div class="form-group">
                    <input type="text" name="subject" id="subj" class="form-control" placeholder="<?php echo e($lang->vendor_subject); ?>">
                </div>
                <div class="form-group">
                    <textarea name="message" id="msg" class="form-control" rows="5" placeholder="<?php echo e($lang->vendor_message); ?>" required=""></textarea>
                </div>
                <input type="hidden" name="email" value="<?php echo e(Auth::guard('user')->user()->email); ?>"> 
                <input type="hidden" name="name" value="<?php echo e(Auth::guard('user')->user()->name); ?>">
                <input type="hidden" name="user_id" value="<?php echo e(Auth::guard('user')->user()->id); ?>">
                <input type="hidden" name="vendor_id" value="<?php echo e($vendor->id); ?>">
          </div>
          <div class="modal-footer">
            <button type="submit" id="emlsub" class="btn btn-default email-btn" <?php echo $lang->rtl == 1 ? 'style="float: left;"':''; ?>><?php echo e($lang->vendor_send); ?></button>
          </div>
           </form>
        </div>
      </div>
    </div>
    <?php endif; ?>
    <!-- Ending of Product email Modal -->

<?php endif; ?>
    <!-- Starting of Scroll to Top Area -->
    <a href="#" class="scrollup">
        <i class="fa fa-angle-double-up"></i>
    </a>
    <!-- Ending of Scroll to Top Area -->

    <!-- jQuary Library -->
<script src="<?php echo e(asset('assets/front/js/all.js')); ?>"></script>

    <?php echo $seo->google_analytics; ?>


    <script type="text/javascript">
        $(".header-bottom-left-wrap").meanmenu({
            meanMenuClose: '<i class="fa fa-bars"></i>' +   ' <?php echo e($lang->all_categories); ?> '    + '<i class="fa fa-times"></i>',
            meanMenuOpen: '<i class="fa fa-bars"></i>' +   ' <?php echo e($lang->all_categories); ?> '    + '<i class="fa fa-angle-down"></i>', 
            meanMenuCloseSize: '14px',
            meanScreenWidth: '767', 
            meanExpandableChildren: true, 
            meanMenuContainer: '.mobileMenuActive', 
            onePage: true
        });

          $('[rel-toggle="tooltip"]').tooltip();
        <?php if($gs->is_loader == 1): ?>
        setTimeout(function(){
            $('#cover').fadeOut(500);
        },1500)
        <?php endif; ?>
    </script>

                                    <?php if(Session::has('subscribe')): ?>
                                    <script type="text/javascript">
                                        $.notify("<?php echo e(Session::get('subscribe')); ?>","success");
                                        
                                    </script>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <script type="text/javascript">
                                        $.notify("<?php echo e($error); ?>","error");
                                        
                                    </script>                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

 <script type="text/javascript">
     $(".ss").keyup(function() {
        var search = $(this).val();
        if(search == ""){
            $(".header-searched-item-list-wrap").hide();
        }
        else {
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/suggest')); ?>",
                    data:{search:search},
                    success:function(data){
                        if(!$.isEmptyObject(data))
                        {
                        $(".header-searched-item-list-wrap").show();
                        $(".header-searched-item-list-wrap ul").html("");
                        var arr = $.map(data, function(el) {
                        return el });
                            for(var k in arr)
                            {
                                var x = arr[k]['name'];
                                var p = x.length  > 50 ? x.substring(0,50)+'...' : x;
                                $(".header-searched-item-list-wrap ul").append('<li><a href="<?php echo e(url('/')); ?>/product/'+arr[k]['id']+'/'+arr[k]['name']+'">'+p+'</a></li>');
                            }
                        }
                        else{
                            $(".header-searched-item-list-wrap").hide();
                        }
                        }
                  }) 
            
        }
     });
 </script>                                   

<script type="text/javascript">
    function remove(id) {
        $("#del"+id).hide();
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/removecart')); ?>",
                    data:{id:id},
                    success:function(data){
                        $(".empty").html("");
                        $(".total").html((data[0] * <?php echo e($curr->value); ?>).toFixed(2));
                        $(".cart-quantity").html(data[2]);
                        $(".cart").html("");
                        if(data[1] == null)
                        {
                            $(".total").html("0.00");
                            $(".cart-quantity").html("0");
                            $(".empty").html("<?php echo e($lang->h); ?>");
                        }

                        var arr = $.map(data[1], function(el) {
                        return el });
                        for(var k in arr)
                        {
                            var x = arr[k]['item']['name'];
                            var p = x.length  > 45 ? x.substring(0,45)+'...' : x;
                            var measure = arr[k]['item']['measure'] != null ? arr[k]['item']['measure'] : "";
                            $(".cart").append(
                            '<div class="single-myCart">'+
            '<p class="cart-close" onclick="remove('+arr[k]['item']['id']+')"><i class="fa fa-close"></i></p>'+
                            '<div class="cart-img">'+
                    '<img src="<?php echo e(asset('assets/images/')); ?>/'+arr[k]['item']['photo']+'" alt="Product image">'+
                            '</div>'+
                            '<div class="cart-info">'+
        '<a href="<?php echo e(url('/')); ?>/product/'+arr[k]['item']['id']+'/'+arr[k]['item']['name']+'" style="color: black; padding: 0 0;">'+'<h5>'+p+'</h5></a>'+
                        '<p><?php echo e($lang->cquantity); ?>: '+arr[k]['qty']+' '+measure+'</p>'+
                        <?php if($gs->sign == 0): ?>
                        '<p><?php echo e($curr->sign); ?>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'</p>'+
                        <?php else: ?>
                        '<p>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'<?php echo e($curr->sign); ?></p>'+
                        <?php endif; ?>
                        '</div>'+
                        '</div>');
                        }                            
                                                    
                      }
              }); 

    }
</script>

    <script type="text/javascript">
    $(document).on("click", ".wish-listt" , function(){
        var max = '';
        var pid = $(this).parent().find('input[type=hidden]').val();
        $("#myModal .modal-content").html('');
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/quick')); ?>",
                    data:{id:pid},
                    success:function(data){
                        $("#myModal .modal-content").append(''+
                            '<div class="modal-header">'+
                            '<button type="button" class="close" data-dismiss="modal">&times;</button>'+
                            '</div>'+
                            '<div class="modal-body">'+
                            '<div class="row">'+
                            '<div class="col-md-3 col-sm-12">'+
                            '<div class="product-review-details-img">'+
                '<img src="<?php echo e(asset('assets/images/')); ?>/'+data[0]+'" alt="Product image">'+
                            '</div>'+
                            '</div>'+
                            '<div class="col-md-9 col-sm-12">'+
                            '<div class="product-review-details-description">'+
                            '<h3>'+data[1]+'</h3>'+
                            '<p class="modal-product-review">'+
                            '<i class="fa fa-star"></i>'+
                            '</p>'+
                            '<div class="product-price">'+
                            '<div class="single-product-price">'+
                             <?php if($gs->sign == 0): ?>
                            '<?php echo e($curr->sign); ?>'+data[2]+' <span><?php echo e($curr->sign); ?>'+data[3]+'</span> '+
                            <?php else: ?>
                            ''+data[2]+'<?php echo e($curr->sign); ?> <span>'+data[3]+'<?php echo e($curr->sign); ?></span> '+
                            <?php endif; ?>
                            '</div>'+
                            '<div class="product-availability">'+
   
                            '</div>'+
                            ' </div>'+
                            '<div class="product-review-description">'+
                            '<h4><?php echo e($lang->dol); ?></h4>'+
                            '<p style="text-align:justify;">'+data[4]+'</p>'+
                            '</div>'+
                            '<div class="product-size">'+
                            '</div>'+
                            '<div class="product-color">'+
                            '</div>'+
                            '<div class="product-quantity">'+
                            '</div>'+
                            '</div>'+   
                            '</div>'+
                            '</div>'+
                            '</div>'+
                            '<div class="modal-footer">'+
                            '</div>');

                            if(data[5] == "0")
                            {
                                if(data[9] == 0)
                                {
                                     $(".product-availability").append(''+
                                    '<?php echo e($lang->availability); ?> '+
                                    '<span style="color:red;">'+
                                    '<i class="fa fa-times-circle-o"></i> '+
                                    '<?php echo e($lang->dni); ?>'+
                                    '</span>'
                                    );                                   
                                }

                            }
                            else
                            {
                                max = data[5] == 'null' ? '': data[5];
                                if(data[9] == 0)
                                {
                                    $(".product-availability").append(''+
                                    '<?php echo e($lang->availability); ?> '+
                                    '<span style="color:green;">'+
                                    '<i class="fa fa-check-square-o"></i> '+
                                    '<?php echo e($lang->sbg); ?>'+
                                    '</span>'
                                    );                                    
                                }
                                $(".product-quantity").append(''+
                                '<form>  <label><?php echo e($lang->dopd); ?> &nbsp;</label>'+
                    '<input type="number" id="mqty" class="qty" min="1" max="'+max+'" value="1" style="width: 40px;">'+
                                '</form>'+   
                                '<input type="hidden" id="mid" value="'+data[7]+'">'+
                                '<a style="cursor: pointer;" class="addToCart-btn" id="maddcart"><?php echo e($lang->hcs); ?></a>'
                                );
                            
                            }
                            if(data[6] != null)
                            {
                            $(".product-size").append(
                            '<p><?php echo e($lang->doo); ?></p>'
                            );
                            for(var size in data[6])
                            $(".product-size").append(
                            '<span style="cursor:pointer;" class="msize">'+data[6][size]+'</span> '
                            );
                            }
                            if(data[8] != null)
                            {
                            $(".product-color").append(
                            '<p><?php echo e($lang->colors); ?></p>'
                            );
                            for(var color in data[8])
                            $(".product-color").append(
                            '<span style="cursor:pointer; background:'+data[8][color]+'" class="mcolor">'+data[8][color]+'</span> '
                            );
                            }                                      
                        }

                      });
        return false;
    });
    </script>
<script>
    $(document).on("click", ".addcart" , function(){
        var pid = $(this).parent().find('input[type=hidden]').val();
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/addcart')); ?>",
                    data:{id:pid},
                    success:function(data){
                        if(data == 0)
                        {
                        $.notify("<?php echo e($gs->cart_error); ?>","error");
                        }
                        else
                        {
                        $(".empty").html("");
                        $(".total").html((data[0] * <?php echo e($curr->value); ?>).toFixed(2));
                        $(".cart-quantity").html(data[2]);
                        var arr = $.map(data[1], function(el) {
                        return el });
                        $(".cart").html("");
                        for(var k in arr)
                        {
                            var x = arr[k]['item']['name'];
                            var p = x.length  > 45 ? x.substring(0,45)+'...' : x;
                            var measure = arr[k]['item']['measure'] != null ? arr[k]['item']['measure'] : "";
                            $(".cart").append(
                              '<div class="single-myCart">'+
            '<p class="cart-close" onclick="remove('+arr[k]['item']['id']+')"><i class="fa fa-close"></i></p>'+
                            '<div class="cart-img">'+
                    '<img src="<?php echo e(asset('assets/images/')); ?>/'+arr[k]['item']['photo']+'" alt="Product image">'+
                            '</div>'+
                            '<div class="cart-info">'+
        '<a href="<?php echo e(url('/')); ?>/product/'+arr[k]['item']['id']+'/'+arr[k]['item']['name']+'" style="color: black; padding: 0 0;">'+'<h5>'+p+'</h5></a>'+
                        '<p><?php echo e($lang->cquantity); ?>: '+arr[k]['qty']+' '+measure+'</p>'+
                        <?php if($gs->sign == 0): ?>
                        '<p><?php echo e($curr->sign); ?>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'</p>'+
                        <?php else: ?>
                        '<p>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'<?php echo e($curr->sign); ?></p>'+
                        <?php endif; ?>
                        '</div>'+
                        '</div>');
                          }
                        $.notify("<?php echo e($gs->cart_success); ?>","success");
                        }
                      }
              }); 
        return false;
    });
    </script>
    <script>
    $(document).on("click", ".removecart" , function(e){
        $(".addToMycart").show();
    });
    </script>
    <script>
    var size = "";
    var colorss = "";
    $(document).on("click", ".msize" , function(){
     $('.msize').removeClass('mselected-size');
     $(this).addClass('mselected-size');
     size = $(this).html();
  });

    $(document).on("click", ".mcolor" , function(){
     $('.mcolor').removeClass('mselected-color');
     $(this).addClass('mselected-color');
     colorss = $(this).html();
  });
     $(document).on("click", "#maddcart" , function(){
        var qty = $("#mqty").val();
        if(qty < 1)
        {
            $.notify("<?php echo e($gs->invalid); ?>","error");
        }
        else
        {
        var pid = $("#mid").val();
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/addnumcart')); ?>",
                    data:{id:pid,qty:qty,size:size,color:colorss},
                    success:function(data){
                        if(data == 0)
                        {
                        $.notify("<?php echo e($gs->cart_error); ?>","error");
                        }
                        else{
                        $(".empty").html("");
                        $(".total").html((data[0] * <?php echo e($curr->value); ?>).toFixed(2));
                        $(".cart-quantity").html(data[2]);
                        var arr = $.map(data[1], function(el) {
                        return el });
                        $(".cart").html("");
                        for(var k in arr)
                        {
                            var x = arr[k]['item']['name'];
                            var p = x.length  > 45 ? x.substring(0,45)+'...' : x;
                            var measure = arr[k]['item']['measure'] != null ? arr[k]['item']['measure'] : "";
                            $(".cart").append(
                            '<div class="single-myCart">'+
            '<p class="cart-close" onclick="remove('+arr[k]['item']['id']+')"><i class="fa fa-close"></i></p>'+
                            '<div class="cart-img">'+
                    '<img src="<?php echo e(asset('assets/images/')); ?>/'+arr[k]['item']['photo']+'" alt="Product image">'+
                            '</div>'+
                            '<div class="cart-info">'+
        '<a href="<?php echo e(url('/')); ?>/product/'+arr[k]['item']['id']+'/'+arr[k]['item']['name']+'" style="color: black; padding: 0 0;">'+'<h5>'+p+'</h5></a>'+
                        '<p><?php echo e($lang->cquantity); ?>: '+arr[k]['qty']+' '+measure+'</p>'+
                        <?php if($gs->sign == 0): ?>
                        '<p><?php echo e($curr->sign); ?>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'</p>'+
                        <?php else: ?>
                        '<p>'+(arr[k]['price'] * <?php echo e($curr->value); ?>).toFixed(2)+'<?php echo e($curr->sign); ?></p>'+
                        <?php endif; ?>
                        '</div>'+
                        '</div>');
                          }
                        $.notify("<?php echo e($gs->cart_success); ?>","success");
                        $("#mqty").val("1");
                        }
                      }
              }); 
        }
     });
    </script>
    <script>
        $(document).on("click", ".lwish" , function(){
            var pid = $(this).parent().find('input[type=hidden]').val();
            window.location = "<?php echo e(url('user/wishlist/product/')); ?>/"+pid;
            return false;
        });
    </script>

    <script>
        $(document).on("click", ".uwish" , function(){
            var pid = $(this).parent().find('input[type=hidden]').val();
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/wish')); ?>",
                    data:{id:pid},
                    success:function(data){
                        if(data == 1)
                        {
                            $.notify("<?php echo e($gs->wish_success); ?>","success");
                        }
                        else {
                            $.notify("<?php echo e($gs->wish_error); ?>","error");
                        }
                      }
              }); 

            return false;
        });
    </script>

    <script>
        $(document).on("click", ".no-wish" , function(){
        return false;
        });
    </script>
<script type="text/javascript">
          $(document).on("submit", "#emailreply" , function(){
          var token = $(this).find('input[name=_token]').val();
          var subject = $(this).find('input[name=subject]').val();
          var message =  $(this).find('textarea[name=message]').val();
          var email = $(this).find('input[name=email]').val();
          var name = $(this).find('input[name=name]').val();
          var user_id = $(this).find('input[name=user_id]').val();
          var vendor_id = $(this).find('input[name=vendor_id]').val();
          $('#subj').prop('disabled', true);
          $('#msg').prop('disabled', true);
          $('#emlsub').prop('disabled', true);
     $.ajax({
            type: 'post',
            url: "<?php echo e(URL::to('/vendor/contact')); ?>",
            data: {
                '_token': token,
                'subject'   : subject,
                'message'  : message,
                'email'   : email,
                'name'  : name,
                'user_id'   : user_id,
                'vendor_id'  : vendor_id
                  },
            success: function() {
          $('#subj').prop('disabled', false);
          $('#msg').prop('disabled', false);
          $('#subj').val('');
          $('#msg').val('');
        $('#emlsub').prop('disabled', false);
        $.notify("Message Sent !!","success");
        $('.ti-close').click();
            }
        });          
          return false;
        });
</script>

    <script>
        $(document).on("click", ".compare" , function(){
        var pid = $(this).parent().find('input[type=hidden]').val();
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/compare')); ?>",
                    data:{id:pid},
                    success:function(data){
                        if(data[0] == 0)
                        {
                            $('.compare-quantity').html(data[1]);
                            $.notify("<?php echo e($gs->compare_success); ?>","success");
                        }
                        else {
                            $.notify("<?php echo e($gs->compare_error); ?>","error");
                        }
                      }
              }); 
        return false;
        });
        $(document).on("click", ".compare-remove" , function(){
            var id = $(this).parent().find('input[type=hidden]').val();
            $(this).parent().parent().hide('slow');
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/removecompare')); ?>",
                    data:{id:id},
                    success:function(data){
                            $.notify("<?php echo e($gs->compare_remove); ?>","success");
                            $('.compare-quantity').html(data[1]);
                        if(data[0] == 1)
                        {
            $('.container-fluid').html('<h2 class="text-center"><?php echo e($lang->no_compare); ?></h2>')
                        }
                    }
                });
        });
        $(document).on("click", ".clear-btn" , function(){
            $('.compare-content-wrap').hide('slow');
            $('.container-fluid').html('<h2 class="text-center"><?php echo e($lang->no_compare); ?></h2>');
            $('.compare-quantity').html('0');
            $.ajax({
                    type: "GET",
                    url:"<?php echo e(URL::to('/json/clearcompare')); ?>",
                });
            return false;
        });

    $(document).on("click", "#product_email" , function(){
        $(".modal-backdrop, .modal.vendor").css('background-color','rgba(0,0,0,0)');
    });
    </script>
    <?php if($gs->is_talkto == 1): ?>
        <!--Start of Tawk.to Script-->
        <?php echo $gs->talkto; ?>

        <!--End of Tawk.to Script-->
    <?php endif; ?>

    <?php echo $__env->yieldContent('scripts'); ?>

</body>
</html>
