<?php
/* Driver template for the PHP_Haanga_rGenerator parser generator. (PHP port of LEMON)
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class Haanga_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof Haanga_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof Haanga_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof Haanga_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof Haanga_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class Haanga_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// code external to the class is included here
#line 2 "lib/Haanga/Compiler/Parser.y"

/*
  +---------------------------------------------------------------------------------+
  | Copyright (c) 2010 César Rodas and Menéame Comunicacions S.L.                   |
  +---------------------------------------------------------------------------------+
  | Redistribution and use in source and binary forms, with or without              |
  | modification, are permitted provided that the following conditions are met:     |
  | 1. Redistributions of source code must retain the above copyright               |
  |    notice, this list of conditions and the following disclaimer.                |
  |                                                                                 |
  | 2. Redistributions in binary form must reproduce the above copyright            |
  |    notice, this list of conditions and the following disclaimer in the          |
  |    documentation and/or other materials provided with the distribution.         |
  |                                                                                 |
  | 3. All advertising materials mentioning features or use of this software        |
  |    must display the following acknowledgement:                                  |
  |    This product includes software developed by César D. Rodas.                  |
  |                                                                                 |
  | 4. Neither the name of the César D. Rodas nor the                               |
  |    names of its contributors may be used to endorse or promote products         |
  |    derived from this software without specific prior written permission.        |
  |                                                                                 |
  | THIS SOFTWARE IS PROVIDED BY CÉSAR D. RODAS ''AS IS'' AND ANY                   |
  | EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED       |
  | WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          |
  | DISCLAIMED. IN NO EVENT SHALL CÉSAR D. RODAS BE LIABLE FOR ANY                  |
  | DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES      |
  | (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;    |
  | LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND     |
  | ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT      |
  | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   |
  | SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE                     |
  +---------------------------------------------------------------------------------+
  | Authors: César Rodas <crodas@php.net>                                           |
  +---------------------------------------------------------------------------------+
*/
#line 136 "lib/Haanga/Compiler/Parser.php"

// declare_class is output here
#line 39 "lib/Haanga/Compiler/Parser.y"
 class Haanga_Compiler_Parser #line 141 "lib/Haanga/Compiler/Parser.php"
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 40 "lib/Haanga/Compiler/Parser.y"

    protected $lex;
    protected $file;

    function __construct($lex, $file='')
    {
        $this->lex  = $lex;
        $this->file = $file;
    }

    function Error($text)
    {
        throw new Haanga_Compiler_Exception($text.' in '.$this->file.':'.$this->lex->getLine());
    }

#line 162 "lib/Haanga/Compiler/Parser.php"

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const T_TAG_OPEN                     =  1;
    const T_NOT                          =  2;
    const T_AND                          =  3;
    const T_OR                           =  4;
    const T_QUESTION                     =  5;
    const T_COLON                        =  6;
    const T_EQ                           =  7;
    const T_NE                           =  8;
    const T_GT                           =  9;
    const T_GE                           = 10;
    const T_LT                           = 11;
    const T_LE                           = 12;
    const T_IN                           = 13;
    const T_PLUS                         = 14;
    const T_MINUS                        = 15;
    const T_CONCAT                       = 16;
    const T_TIMES                        = 17;
    const T_DIV                          = 18;
    const T_MOD                          = 19;
    const T_PIPE                         = 20;
    const T_BITWISE                      = 21;
    const T_FILTER_PIPE                  = 22;
    const T_HTML                         = 23;
    const T_COMMENT                      = 24;
    const T_PRINT_OPEN                   = 25;
    const T_PRINT_CLOSE                  = 26;
    const T_EXTENDS                      = 27;
    const T_TAG_CLOSE                    = 28;
    const T_INCLUDE                      = 29;
    const T_AUTOESCAPE                   = 30;
    const T_CUSTOM_END                   = 31;
    const T_CUSTOM_TAG                   = 32;
    const T_AS                           = 33;
    const T_CUSTOM_BLOCK                 = 34;
    const T_SPACEFULL                    = 35;
    const T_WITH                         = 36;
    const T_SET                          = 37;
    const T_ASSIGN                       = 38;
    const T_LOAD                         = 39;
    const T_FOR                          = 40;
    const T_COMMA                        = 41;
    const T_STEP                         = 42;
    const T_EMPTY                        = 43;
    const T_IF                           = 44;
    const T_ELSE                         = 45;
    const T_IFCHANGED                    = 46;
    const T_IFEQUAL                      = 47;
    const T_IFNOTEQUAL                   = 48;
    const T_BLOCK                        = 49;
    const T_FILTER                       = 50;
    const T_REGROUP                      = 51;
    const T_BY                           = 52;
    const T_TRUE                         = 53;
    const T_FALSE                        = 54;
    const T_STRING                       = 55;
    const T_INTL                         = 56;
    const T_RPARENT                      = 57;
    const T_LPARENT                      = 58;
    const T_OBJ                          = 59;
    const T_DOT                          = 60;
    const T_CLASS                        = 61;
    const T_BRACKETS_OPEN                = 62;
    const T_BRACKETS_CLOSE               = 63;
    const T_ALPHA                        = 64;
    const T_DOTDOT                       = 65;
    const T_NUMERIC                      = 66;
    const YY_NO_ACTION = 374;
    const YY_ACCEPT_ACTION = 373;
    const YY_ERROR_ACTION = 372;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 1586;
static public $yy_action = array(
 /*     0 */    33,   34,   35,   32,   31,   31,   31,   31,   31,   31,
 /*    10 */    31,   36,   36,   36,   27,   27,   27,   25,   30,   54,
 /*    20 */    62,   51,   74,  193,   43,  241,   45,  175,   66,   71,
 /*    30 */   255,  101,   65,  251,  144,  117,   28,  195,   46,   39,
 /*    40 */    40,   61,   58,   56,   54,   70,   51,   74,  168,   43,
 /*    50 */    69,   45,  175,   66,   71,   55,  101,   65,  105,  252,
 /*    60 */    38,   28,  160,   46,   39,   40,   61,   58,   56,   33,
 /*    70 */    34,   35,   60,   31,   31,   31,   31,   31,   31,   31,
 /*    80 */    36,   36,   36,   27,   27,   27,   25,   30,   67,   33,
 /*    90 */    34,   35,  204,   31,   31,   31,   31,   31,   31,   31,
 /*   100 */    36,   36,   36,   27,   27,   27,   25,   30,   54,   37,
 /*   110 */    51,   74,  146,   43,  369,   45,  175,   66,   71,  261,
 /*   120 */   101,   65,  373,   80,  167,   28,  153,   46,   39,   40,
 /*   130 */    61,   58,   56,  192,  258,  134,  220,  273,  273,  120,
 /*   140 */   273,   25,   30,  270,   54,  190,   51,   74,  183,   43,
 /*   150 */   203,   45,  175,   66,   71,  273,  101,   65,  246,  227,
 /*   160 */   177,   28,  249,   46,   39,   40,   61,   58,   56,  174,
 /*   170 */   273,   54,   63,   51,   74,  155,   43,  232,   45,  175,
 /*   180 */    66,   71,  208,  101,   65,  259,  115,  123,   28,  158,
 /*   190 */    46,   39,   40,   61,   58,   56,   33,   34,   35,  174,
 /*   200 */    31,   31,   31,   31,   31,   31,   31,   36,   36,   36,
 /*   210 */    27,   27,   27,   25,   30,  273,  273,  198,  273,  110,
 /*   220 */   238,  106,   54,   55,   51,   74,  169,   43,  263,   45,
 /*   230 */   175,   66,   71,  273,  101,   65,  205,  230,  228,   28,
 /*   240 */   165,   46,   39,   40,   61,   58,   56,  229,  273,   54,
 /*   250 */   238,   51,   74,  100,   43,  272,   45,  175,   66,   71,
 /*   260 */   102,  101,   65,  253,  262,  277,   28,   68,   46,   39,
 /*   270 */    40,   61,   58,   56,   54,   62,   51,   74,  150,   43,
 /*   280 */   122,   45,  175,   66,   71,  209,  101,   65,  103,  109,
 /*   290 */   104,   28,  119,   46,   39,   40,   61,   58,   56,   54,
 /*   300 */    57,   51,   74,  185,   43,  212,   45,  175,   66,   71,
 /*   310 */   118,  101,   65,   59,  254,  239,   28,  217,   46,   39,
 /*   320 */    40,   61,   58,   56,   54,   86,   51,   74,  151,   43,
 /*   330 */   201,   45,  175,   66,   71,  111,  101,   65,  206,  218,
 /*   340 */   224,   28,  207,   46,   39,   40,   61,   58,   56,   33,
 /*   350 */    34,   35,  116,   31,   31,   31,   31,   31,   31,   31,
 /*   360 */    36,   36,   36,   27,   27,   27,   25,   30,  200,   54,
 /*   370 */   176,   51,   74,  196,   43,   82,   45,  175,   66,   71,
 /*   380 */   275,  101,   65,  240,   95,   96,   28,   98,   46,   39,
 /*   390 */    40,   61,   58,   56,   54,   81,   51,   74,   64,   43,
 /*   400 */    97,   45,  175,   66,   71,   90,  101,   65,   88,   93,
 /*   410 */    89,   28,  235,   46,   39,   40,   61,   58,   56,   54,
 /*   420 */    99,   51,   74,  152,   43,   91,   45,  175,   66,   71,
 /*   430 */    83,  101,   65,   84,   87,   92,   28,   77,   46,   39,
 /*   440 */    40,   61,   58,   56,   54,   78,   51,   74,  172,   43,
 /*   450 */    94,   45,  175,   66,   71,   85,  101,   65,   79,  192,
 /*   460 */   192,   28,  192,   46,   39,   40,   61,   58,   56,   54,
 /*   470 */   192,   51,   74,  197,   43,  192,   45,  175,   66,   71,
 /*   480 */   192,  101,   65,  192,  192,  192,   28,  192,   46,   39,
 /*   490 */    40,   61,   58,   56,   54,  192,   51,   74,  173,   43,
 /*   500 */   192,   45,  175,   66,   71,  192,  101,   65,  192,  192,
 /*   510 */   192,   28,  192,   46,   39,   40,   61,   58,   56,   54,
 /*   520 */   192,   51,   74,  154,   43,  192,   45,  175,   66,   71,
 /*   530 */   192,  101,   65,  192,  192,  192,   28,  192,   46,   39,
 /*   540 */    40,   61,   58,   56,   54,  192,   51,   74,  179,   43,
 /*   550 */   192,   45,  175,   66,   71,  192,  101,   65,  192,  192,
 /*   560 */   192,   28,  192,   46,   39,   40,   61,   58,   56,   54,
 /*   570 */   192,   51,   74,  194,   43,  192,   45,  175,   66,   71,
 /*   580 */   192,  101,   65,  192,  192,  192,   28,  192,   46,   39,
 /*   590 */    40,   61,   58,   56,   54,  192,   51,   74,  187,   43,
 /*   600 */   192,   45,  175,   66,   71,  192,  101,   65,  192,  192,
 /*   610 */   192,   28,  192,   46,   39,   40,   61,   58,   56,   54,
 /*   620 */   192,   51,   74,  148,   43,  192,   45,  175,   66,   71,
 /*   630 */   192,  101,   65,  192,  192,  192,   28,  192,   46,   39,
 /*   640 */    40,   61,   58,   56,   54,  192,   51,   74,  170,   43,
 /*   650 */   192,   45,  175,   66,   71,  192,  101,   65,  192,  192,
 /*   660 */   192,   28,  192,   46,   39,   40,   61,   58,   56,   54,
 /*   670 */   192,   51,   74,  178,   43,  192,   45,  175,   66,   71,
 /*   680 */   192,  101,   65,  268,  134,  220,   28,  192,   46,   39,
 /*   690 */    40,   61,   58,   56,   34,   35,  192,   31,   31,   31,
 /*   700 */    31,   31,   31,   31,   36,   36,   36,   27,   27,   27,
 /*   710 */    25,   30,   35,  192,   31,   31,   31,   31,   31,   31,
 /*   720 */    31,   36,   36,   36,   27,   27,   27,   25,   30,   31,
 /*   730 */    31,   31,   31,   31,   31,   31,   36,   36,   36,   27,
 /*   740 */    27,   27,   25,   30,  174,  192,  226,   62,  273,  273,
 /*   750 */   192,  273,  192,  274,  192,  192,  257,  225,  174,  250,
 /*   760 */   273,  273,   73,  273,  192,  260,  273,  134,  220,  192,
 /*   770 */    52,  219,  192,   24,  273,  273,   72,  273,  273,  178,
 /*   780 */   192,  273,  256,  256,  251,  144,  174,  192,   62,  247,
 /*   790 */   134,  220,  273,  273,  121,  238,  256,  256,  251,  144,
 /*   800 */   192,  178,  273,  273,  163,  273,  143,  273,  192,  238,
 /*   810 */   192,  269,  134,  220,  174,  192,   62,  192,  273,  273,
 /*   820 */   273,  273,  216,  192,  266,  266,  251,  144,  192,   26,
 /*   830 */   273,  273,  192,  273,  192,  273,  273,  238,  192,  192,
 /*   840 */    52,  192,  251,  144,   17,  174,  192,  192,  273,  192,
 /*   850 */   192,  273,  256,  256,  251,  144,  237,  192,  114,  236,
 /*   860 */   192,  273,  273,  273,  273,  238,  214,  215,   29,  257,
 /*   870 */    49,   52,  250,  192,  174,  192,  192,  192,  260,  273,
 /*   880 */   134,  220,   19,  256,  256,  251,  144,  107,  236,  192,
 /*   890 */   273,  273,  192,  273,  273,  192,  238,  192,  257,   47,
 /*   900 */    52,  250,  192,  174,  214,  215,   29,  260,  273,  134,
 /*   910 */   220,  192,  256,  256,  251,  144,  113,  192,  192,  273,
 /*   920 */   273,  192,  273,  273,  137,  238,  192,  163,  142,  136,
 /*   930 */   141,  164,  174,  202,  269,  134,  220,  273,  192,  134,
 /*   940 */   220,  256,  256,  251,  144,  112,  236,  192,  273,  273,
 /*   950 */   192,  273,  273,  192,  238,  192,  257,   50,  192,  250,
 /*   960 */    27,   27,   27,   25,   30,  260,  273,  134,  220,  192,
 /*   970 */   256,  256,  251,  144,   44,   76,   76,   75,   53,  192,
 /*   980 */   192,  273,  192,  238,  199,  192,  174,  156,  245,  244,
 /*   990 */   242,  243,  233,  222,  223,  221,  131,  210,  276,    5,
 /*  1000 */   108,  192,  273,  273,  181,  273,  202,  178,  134,  220,
 /*  1010 */   166,  192,  191,  192,  174,  271,  267,  269,  134,  220,
 /*  1020 */   273,  214,  215,   29,  256,  256,  251,  144,  234,  192,
 /*  1030 */   273,  273,  210,  273,  192,  273,  192,  238,  188,  211,
 /*  1040 */   174,  202,  192,  134,  220,   11,  192,  192,  273,  134,
 /*  1050 */   220,  192,  256,  256,  251,  144,  273,  273,  192,  273,
 /*  1060 */   192,  192,  192,  273,  192,  238,  192,  214,  215,   29,
 /*  1070 */   192,  192,  178,  192,  273,  163,  126,  138,  266,  266,
 /*  1080 */   251,  144,  269,  134,  220,  192,  192,  178,  192,  273,
 /*  1090 */   166,  238,  191,  135,  192,  271,  267,  269,  134,  220,
 /*  1100 */   192,  192,  192,  192,  178,  192,  139,  166,  192,  191,
 /*  1110 */   192,  192,  271,  267,  269,  134,  220,  178,  192,  189,
 /*  1120 */   166,  124,  191,  192,  192,  271,  267,  269,  134,  220,
 /*  1130 */   134,  220,  178,  192,  157,  166,  125,  191,  192,  192,
 /*  1140 */   271,  267,  269,  134,  220,  134,  220,  178,  192,  127,
 /*  1150 */   166,  192,  191,  192,  192,  271,  267,  269,  134,  220,
 /*  1160 */   178,  192,  133,  166,  192,  191,  192,  192,  271,  267,
 /*  1170 */   269,  134,  220,  178,  192,  162,  166,  132,  191,  192,
 /*  1180 */   192,  271,  267,  269,  134,  220,  134,  220,  178,  192,
 /*  1190 */   130,  166,  192,  191,  192,  192,  271,  267,  269,  134,
 /*  1200 */   220,  178,  192,  192,  166,  264,  191,  192,  192,  271,
 /*  1210 */   267,  269,  134,  220,  174,  192,  178,  192,  192,  166,
 /*  1220 */   192,  191,  192,  128,  271,  267,  269,  134,  220,  147,
 /*  1230 */   273,  273,  192,  273,  178,    1,  192,  166,  192,  191,
 /*  1240 */   134,  220,  271,  267,  269,  134,  220,  192,  273,  192,
 /*  1250 */   265,  192,  192,  192,  251,  144,    3,  214,  215,   29,
 /*  1260 */     4,  178,  192,  273,  166,  238,  191,  192,  192,  271,
 /*  1270 */   267,  269,  134,  220,  129,  213,  192,  192,  214,  215,
 /*  1280 */    29,  192,  214,  215,   29,  178,  134,  220,  166,  192,
 /*  1290 */   191,  192,  192,  271,  267,  269,  134,  220,  178,  192,
 /*  1300 */   192,  166,  192,  191,  192,  192,   42,  267,  269,  134,
 /*  1310 */   220,  178,  192,  186,  166,  192,  191,  192,  192,  161,
 /*  1320 */   267,  269,  134,  220,  134,  220,  178,  192,  192,  166,
 /*  1330 */   192,  191,  192,  192,  149,  267,  269,  134,  220,  178,
 /*  1340 */   192,  192,  166,  236,  191,  192,  192,   41,  267,  269,
 /*  1350 */   134,  220,  192,  257,   48,  192,  250,  192,  192,  145,
 /*  1360 */   192,  192,  260,  192,  134,  220,  192,    6,  192,  257,
 /*  1370 */   192,  192,  250,  192,  192,  231,  192,  192,  260,  192,
 /*  1380 */   134,  220,  159,  192,  192,  257,  192,  184,  250,  214,
 /*  1390 */   215,   29,  257,  192,  260,  250,  134,  220,  134,  220,
 /*  1400 */   171,  260,  192,  134,  220,  178,  192,  192,  163,  248,
 /*  1410 */   140,  134,  220,  182,  192,  269,  134,  220,   22,  257,
 /*  1420 */   192,   16,  250,  257,   13,  192,  250,  180,  260,  192,
 /*  1430 */   134,  220,  260,    8,  134,  220,   21,  192,  134,  220,
 /*  1440 */   214,  215,   29,  214,  215,   29,  214,  215,   29,    7,
 /*  1450 */   192,  192,  192,  192,  192,  214,  215,   29,  214,  215,
 /*  1460 */    29,    9,  192,  192,  192,  192,  192,  192,  192,  192,
 /*  1470 */   192,  214,  215,   29,   15,  192,  192,  192,  192,  192,
 /*  1480 */   192,  192,  192,  214,  215,   29,    2,  192,  192,  192,
 /*  1490 */   192,  192,  192,  192,  192,  192,  214,  215,   29,   23,
 /*  1500 */   192,  192,  192,  192,  192,  192,  192,  192,  214,  215,
 /*  1510 */    29,   20,  192,  192,  192,  192,  192,  192,  192,  192,
 /*  1520 */   192,  214,  215,   29,   10,  192,  192,  192,  192,  192,
 /*  1530 */   192,  192,  192,  214,  215,   29,   18,  192,  192,  192,
 /*  1540 */   192,  192,  192,  192,  192,  192,  214,  215,   29,   12,
 /*  1550 */   192,  192,  192,  192,  192,  192,  192,  192,  214,  215,
 /*  1560 */    29,   14,  192,  192,  192,  192,  192,  192,  192,  192,
 /*  1570 */   192,  214,  215,   29,  192,  192,  192,  192,  192,  192,
 /*  1580 */   192,  192,  192,  214,  215,   29,
    );
    static public $yy_lookahead = array(
 /*     0 */     3,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*    10 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   27,
 /*    20 */    22,   29,   30,   31,   32,   63,   34,   35,   36,   37,
 /*    30 */    28,   39,   40,   55,   56,   28,   44,   45,   46,   47,
 /*    40 */    48,   49,   50,   51,   27,   33,   29,   30,   31,   32,
 /*    50 */    52,   34,   35,   36,   37,    6,   39,   40,   28,   28,
 /*    60 */    13,   44,   45,   46,   47,   48,   49,   50,   51,    3,
 /*    70 */     4,    5,   42,    7,    8,    9,   10,   11,   12,   13,
 /*    80 */    14,   15,   16,   17,   18,   19,   20,   21,   41,    3,
 /*    90 */     4,    5,   26,    7,    8,    9,   10,   11,   12,   13,
 /*   100 */    14,   15,   16,   17,   18,   19,   20,   21,   27,   38,
 /*   110 */    29,   30,   31,   32,   65,   34,   35,   36,   37,   28,
 /*   120 */    39,   40,   68,   69,   83,   44,   45,   46,   47,   48,
 /*   130 */    49,   50,   51,   92,   28,   94,   95,   31,   32,   28,
 /*   140 */    34,   20,   21,   57,   27,   55,   29,   30,   31,   32,
 /*   150 */    28,   34,   35,   36,   37,   49,   39,   40,   28,   28,
 /*   160 */    43,   44,   28,   46,   47,   48,   49,   50,   51,   15,
 /*   170 */    64,   27,   22,   29,   30,   31,   32,   28,   34,   35,
 /*   180 */    36,   37,   28,   39,   40,   28,   28,   28,   44,   45,
 /*   190 */    46,   47,   48,   49,   50,   51,    3,    4,    5,   15,
 /*   200 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   210 */    17,   18,   19,   20,   21,   31,   32,   28,   34,   28,
 /*   220 */    66,   28,   27,    6,   29,   30,   31,   32,   28,   34,
 /*   230 */    35,   36,   37,   49,   39,   40,   28,   28,   28,   44,
 /*   240 */    45,   46,   47,   48,   49,   50,   51,   28,   64,   27,
 /*   250 */    66,   29,   30,   31,   32,   28,   34,   35,   36,   37,
 /*   260 */    28,   39,   40,   28,   57,   28,   44,   33,   46,   47,
 /*   270 */    48,   49,   50,   51,   27,   22,   29,   30,   31,   32,
 /*   280 */    28,   34,   35,   36,   37,   28,   39,   40,   28,   28,
 /*   290 */    28,   44,   28,   46,   47,   48,   49,   50,   51,   27,
 /*   300 */    13,   29,   30,   31,   32,   28,   34,   35,   36,   37,
 /*   310 */    28,   39,   40,   65,   28,   66,   44,   28,   46,   47,
 /*   320 */    48,   49,   50,   51,   27,   69,   29,   30,   31,   32,
 /*   330 */    28,   34,   35,   36,   37,   28,   39,   40,   28,   28,
 /*   340 */    28,   44,   28,   46,   47,   48,   49,   50,   51,    3,
 /*   350 */     4,    5,   28,    7,    8,    9,   10,   11,   12,   13,
 /*   360 */    14,   15,   16,   17,   18,   19,   20,   21,   70,   27,
 /*   370 */    92,   29,   30,   31,   32,   69,   34,   35,   36,   37,
 /*   380 */    86,   39,   40,   95,   69,   69,   44,   69,   46,   47,
 /*   390 */    48,   49,   50,   51,   27,   69,   29,   30,   31,   32,
 /*   400 */    69,   34,   35,   36,   37,   69,   39,   40,   69,   69,
 /*   410 */    69,   44,   95,   46,   47,   48,   49,   50,   51,   27,
 /*   420 */    69,   29,   30,   31,   32,   69,   34,   35,   36,   37,
 /*   430 */    69,   39,   40,   69,   69,   69,   44,   69,   46,   47,
 /*   440 */    48,   49,   50,   51,   27,   69,   29,   30,   31,   32,
 /*   450 */    69,   34,   35,   36,   37,   69,   39,   40,   69,   96,
 /*   460 */    96,   44,   96,   46,   47,   48,   49,   50,   51,   27,
 /*   470 */    96,   29,   30,   31,   32,   96,   34,   35,   36,   37,
 /*   480 */    96,   39,   40,   96,   96,   96,   44,   96,   46,   47,
 /*   490 */    48,   49,   50,   51,   27,   96,   29,   30,   31,   32,
 /*   500 */    96,   34,   35,   36,   37,   96,   39,   40,   96,   96,
 /*   510 */    96,   44,   96,   46,   47,   48,   49,   50,   51,   27,
 /*   520 */    96,   29,   30,   31,   32,   96,   34,   35,   36,   37,
 /*   530 */    96,   39,   40,   96,   96,   96,   44,   96,   46,   47,
 /*   540 */    48,   49,   50,   51,   27,   96,   29,   30,   31,   32,
 /*   550 */    96,   34,   35,   36,   37,   96,   39,   40,   96,   96,
 /*   560 */    96,   44,   96,   46,   47,   48,   49,   50,   51,   27,
 /*   570 */    96,   29,   30,   31,   32,   96,   34,   35,   36,   37,
 /*   580 */    96,   39,   40,   96,   96,   96,   44,   96,   46,   47,
 /*   590 */    48,   49,   50,   51,   27,   96,   29,   30,   31,   32,
 /*   600 */    96,   34,   35,   36,   37,   96,   39,   40,   96,   96,
 /*   610 */    96,   44,   96,   46,   47,   48,   49,   50,   51,   27,
 /*   620 */    96,   29,   30,   31,   32,   96,   34,   35,   36,   37,
 /*   630 */    96,   39,   40,   96,   96,   96,   44,   96,   46,   47,
 /*   640 */    48,   49,   50,   51,   27,   96,   29,   30,   31,   32,
 /*   650 */    96,   34,   35,   36,   37,   96,   39,   40,   96,   96,
 /*   660 */    96,   44,   96,   46,   47,   48,   49,   50,   51,   27,
 /*   670 */    96,   29,   30,   83,   32,   96,   34,   35,   36,   37,
 /*   680 */    96,   39,   40,   93,   94,   95,   44,   96,   46,   47,
 /*   690 */    48,   49,   50,   51,    4,    5,   96,    7,    8,    9,
 /*   700 */    10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
 /*   710 */    20,   21,    5,   96,    7,    8,    9,   10,   11,   12,
 /*   720 */    13,   14,   15,   16,   17,   18,   19,   20,   21,    7,
 /*   730 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   740 */    18,   19,   20,   21,   15,   96,   73,   22,   31,   32,
 /*   750 */    96,   34,   96,   28,   96,   96,   83,   28,   15,   86,
 /*   760 */    31,   32,   33,   34,   96,   92,   49,   94,   95,   96,
 /*   770 */    41,   28,   96,    2,   31,   32,   33,   34,   49,   83,
 /*   780 */    96,   64,   53,   54,   55,   56,   15,   96,   22,   93,
 /*   790 */    94,   95,   49,   64,   28,   66,   53,   54,   55,   56,
 /*   800 */    96,   83,   31,   32,   86,   34,   88,   64,   96,   66,
 /*   810 */    96,   93,   94,   95,   15,   96,   22,   96,   31,   32,
 /*   820 */    49,   34,   28,   96,   53,   54,   55,   56,   96,   58,
 /*   830 */    31,   32,   96,   34,   96,   64,   49,   66,   96,   96,
 /*   840 */    41,   96,   55,   56,    1,   15,   96,   96,   49,   96,
 /*   850 */    96,   64,   53,   54,   55,   56,   57,   96,   28,   73,
 /*   860 */    96,   31,   32,   64,   34,   66,   23,   24,   25,   83,
 /*   870 */    84,   41,   86,   96,   15,   96,   96,   96,   92,   49,
 /*   880 */    94,   95,    1,   53,   54,   55,   56,   28,   73,   96,
 /*   890 */    31,   32,   96,   34,   64,   96,   66,   96,   83,   84,
 /*   900 */    41,   86,   96,   15,   23,   24,   25,   92,   49,   94,
 /*   910 */    95,   96,   53,   54,   55,   56,   28,   96,   96,   31,
 /*   920 */    32,   96,   34,   64,   83,   66,   96,   86,   83,   88,
 /*   930 */    89,   90,   15,   92,   93,   94,   95,   49,   96,   94,
 /*   940 */    95,   53,   54,   55,   56,   28,   73,   96,   31,   32,
 /*   950 */    96,   34,   64,   96,   66,   96,   83,   84,   96,   86,
 /*   960 */    17,   18,   19,   20,   21,   92,   49,   94,   95,   96,
 /*   970 */    53,   54,   55,   56,   58,   59,   60,   61,   62,   96,
 /*   980 */    96,   64,   96,   66,   71,   96,   15,   74,   75,   76,
 /*   990 */    77,   78,   79,   80,   81,   82,   72,   83,   85,    1,
 /*  1000 */    87,   96,   31,   32,   90,   34,   92,   83,   94,   95,
 /*  1010 */    86,   96,   88,   96,   15,   91,   92,   93,   94,   95,
 /*  1020 */    49,   23,   24,   25,   53,   54,   55,   56,   57,   96,
 /*  1030 */    31,   32,   83,   34,   96,   64,   96,   66,   83,   90,
 /*  1040 */    15,   92,   96,   94,   95,    1,   96,   96,   49,   94,
 /*  1050 */    95,   96,   53,   54,   55,   56,   31,   32,   96,   34,
 /*  1060 */    96,   96,   96,   64,   96,   66,   96,   23,   24,   25,
 /*  1070 */    96,   96,   83,   96,   49,   86,   72,   88,   53,   54,
 /*  1080 */    55,   56,   93,   94,   95,   96,   96,   83,   96,   64,
 /*  1090 */    86,   66,   88,   72,   96,   91,   92,   93,   94,   95,
 /*  1100 */    96,   96,   96,   96,   83,   96,   72,   86,   96,   88,
 /*  1110 */    96,   96,   91,   92,   93,   94,   95,   83,   96,   83,
 /*  1120 */    86,   72,   88,   96,   96,   91,   92,   93,   94,   95,
 /*  1130 */    94,   95,   83,   96,   83,   86,   72,   88,   96,   96,
 /*  1140 */    91,   92,   93,   94,   95,   94,   95,   83,   96,   72,
 /*  1150 */    86,   96,   88,   96,   96,   91,   92,   93,   94,   95,
 /*  1160 */    83,   96,   72,   86,   96,   88,   96,   96,   91,   92,
 /*  1170 */    93,   94,   95,   83,   96,   83,   86,   72,   88,   96,
 /*  1180 */    96,   91,   92,   93,   94,   95,   94,   95,   83,   96,
 /*  1190 */    72,   86,   96,   88,   96,   96,   91,   92,   93,   94,
 /*  1200 */    95,   83,   96,   96,   86,   72,   88,   96,   96,   91,
 /*  1210 */    92,   93,   94,   95,   15,   96,   83,   96,   96,   86,
 /*  1220 */    96,   88,   96,   72,   91,   92,   93,   94,   95,   83,
 /*  1230 */    31,   32,   96,   34,   83,    1,   96,   86,   96,   88,
 /*  1240 */    94,   95,   91,   92,   93,   94,   95,   96,   49,   96,
 /*  1250 */    72,   96,   96,   96,   55,   56,    1,   23,   24,   25,
 /*  1260 */     1,   83,   96,   64,   86,   66,   88,   96,   96,   91,
 /*  1270 */    92,   93,   94,   95,   72,   83,   96,   96,   23,   24,
 /*  1280 */    25,   96,   23,   24,   25,   83,   94,   95,   86,   96,
 /*  1290 */    88,   96,   96,   91,   92,   93,   94,   95,   83,   96,
 /*  1300 */    96,   86,   96,   88,   96,   96,   91,   92,   93,   94,
 /*  1310 */    95,   83,   96,   83,   86,   96,   88,   96,   96,   91,
 /*  1320 */    92,   93,   94,   95,   94,   95,   83,   96,   96,   86,
 /*  1330 */    96,   88,   96,   96,   91,   92,   93,   94,   95,   83,
 /*  1340 */    96,   96,   86,   73,   88,   96,   96,   91,   92,   93,
 /*  1350 */    94,   95,   96,   83,   84,   96,   86,   96,   96,   73,
 /*  1360 */    96,   96,   92,   96,   94,   95,   96,    1,   96,   83,
 /*  1370 */    96,   96,   86,   96,   96,   73,   96,   96,   92,   96,
 /*  1380 */    94,   95,   73,   96,   96,   83,   96,   83,   86,   23,
 /*  1390 */    24,   25,   83,   96,   92,   86,   94,   95,   94,   95,
 /*  1400 */    83,   92,   96,   94,   95,   83,   96,   96,   86,   73,
 /*  1410 */    88,   94,   95,   73,   96,   93,   94,   95,    1,   83,
 /*  1420 */    96,    1,   86,   83,    1,   96,   86,   83,   92,   96,
 /*  1430 */    94,   95,   92,    1,   94,   95,    1,   96,   94,   95,
 /*  1440 */    23,   24,   25,   23,   24,   25,   23,   24,   25,    1,
 /*  1450 */    96,   96,   96,   96,   96,   23,   24,   25,   23,   24,
 /*  1460 */    25,    1,   96,   96,   96,   96,   96,   96,   96,   96,
 /*  1470 */    96,   23,   24,   25,    1,   96,   96,   96,   96,   96,
 /*  1480 */    96,   96,   96,   23,   24,   25,    1,   96,   96,   96,
 /*  1490 */    96,   96,   96,   96,   96,   96,   23,   24,   25,    1,
 /*  1500 */    96,   96,   96,   96,   96,   96,   96,   96,   23,   24,
 /*  1510 */    25,    1,   96,   96,   96,   96,   96,   96,   96,   96,
 /*  1520 */    96,   23,   24,   25,    1,   96,   96,   96,   96,   96,
 /*  1530 */    96,   96,   96,   23,   24,   25,    1,   96,   96,   96,
 /*  1540 */    96,   96,   96,   96,   96,   96,   23,   24,   25,    1,
 /*  1550 */    96,   96,   96,   96,   96,   96,   96,   96,   23,   24,
 /*  1560 */    25,    1,   96,   96,   96,   96,   96,   96,   96,   96,
 /*  1570 */    96,   23,   24,   25,   96,   96,   96,   96,   96,   96,
 /*  1580 */    96,   96,   96,   23,   24,   25,
);
    const YY_SHIFT_USE_DFLT = -39;
    const YY_SHIFT_MAX = 197;
    static public $yy_shift_ofst = array(
 /*     0 */   -39,  144,  195,   81,   -8,  117,   17,  542,  517,  592,
 /*    10 */   567,  617,  392,  492,  297,  272,  247,  222,  342,  442,
 /*    20 */   367,  467,  417,  642,  771,  771,  771,  771,  771,  771,
 /*    30 */   771,  771,  771,  771,  771,  771,  771,  771, 1199, 1025,
 /*    40 */  1025, 1025, 1025,  743,  971,  917,  888,  729,  830,  799,
 /*    50 */   859,  999,  999,  999,  999,  999,  787,  787,  787,  184,
 /*    60 */   184,  184,  717,  717,  106,  717,  717,  717,  717,  717,
 /*    70 */   717,  717,  717,  717,  717,  717,  717, 1535, 1560, 1510,
 /*    80 */  1498, 1485, 1523, 1548, 1423, 1255, 1259, 1234, 1417,  998,
 /*    90 */  1044,  843,  881, 1366, 1460, 1435, 1448, 1473, 1432, 1420,
 /*   100 */   154,  -22,  -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,
 /*   110 */   -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,  -39,
 /*   120 */   -39,  -39,  -39,  -39,   86,   -3,  193,   66,  346,  346,
 /*   130 */   690,  707,  722,  722,  916,  943,  725,   49,  766,  121,
 /*   140 */   794,   30,   47,   -2,   90,  149,  134,   71,  131,  158,
 /*   150 */   189,  122,   31,    7,    2,   91,  130,   12,  111,  -38,
 /*   160 */   159,  324,  287,  150,  248,  282,  150,  264,  277,  286,
 /*   170 */   289,  312,  314,  311,  249,  307,  310,  261,  217,  219,
 /*   180 */   209,  191,  208,  227,  252,  257,  237,  235,  234,  262,
 /*   190 */   207,  253,  232,  200,  210,  260,  302,  157,
);
    const YY_REDUCE_USE_DFLT = -1;
    const YY_REDUCE_MAX = 123;
    static public $yy_reduce_ofst = array(
 /*     0 */    54,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*    10 */   913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
 /*    20 */   913,  913,  913,  913, 1202, 1178, 1049, 1034, 1004, 1077,
 /*    30 */  1133, 1105, 1090, 1118,  924, 1064, 1021, 1151,  841, 1256,
 /*    40 */  1215, 1243, 1228,  815,  786, 1270,  873,  673,  673,  673,
 /*    50 */   673, 1286, 1302, 1309, 1340, 1336,  718, 1322,  989,  949,
 /*    60 */   914,   41,  696,  590, 1230,  845,  955, 1092, 1304, 1051,
 /*    70 */  1192, 1146, 1317, 1344, 1036,  288,  317,  298,  298,  298,
 /*    80 */   298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
 /*    90 */   298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
 /*   100 */   278,  294,  356,  306,  315,  339,  256,  340,  341,  336,
 /*   110 */   331,  316,  318,  326,  351,  386,  365,  364,  361,  389,
 /*   120 */   366,  368,  381,  376,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(),
        /* 1 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 45, 46, 47, 48, 49, 50, 51, ),
        /* 2 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 45, 46, 47, 48, 49, 50, 51, ),
        /* 3 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 45, 46, 47, 48, 49, 50, 51, ),
        /* 4 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 45, 46, 47, 48, 49, 50, 51, ),
        /* 5 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 43, 44, 46, 47, 48, 49, 50, 51, ),
        /* 6 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 45, 46, 47, 48, 49, 50, 51, ),
        /* 7 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 8 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 9 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 10 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 11 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 12 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 13 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 14 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 15 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 16 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 17 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 18 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 19 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 20 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 21 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 22 */ array(27, 29, 30, 31, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 23 */ array(27, 29, 30, 32, 34, 35, 36, 37, 39, 40, 44, 46, 47, 48, 49, 50, 51, ),
        /* 24 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 25 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 26 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 27 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 28 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 29 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 30 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 31 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 32 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 33 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 34 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 35 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 36 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 37 */ array(2, 15, 31, 32, 34, 49, 53, 54, 55, 56, 58, 64, 66, ),
        /* 38 */ array(15, 31, 32, 34, 49, 55, 56, 64, 66, ),
        /* 39 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 40 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 41 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 42 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 43 */ array(15, 28, 31, 32, 33, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 44 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 57, 64, 66, ),
        /* 45 */ array(15, 28, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 46 */ array(15, 28, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 47 */ array(15, 28, 31, 32, 33, 34, 41, 49, 53, 54, 55, 56, 64, 66, ),
        /* 48 */ array(15, 28, 31, 32, 34, 41, 49, 53, 54, 55, 56, 64, 66, ),
        /* 49 */ array(15, 31, 32, 34, 41, 49, 53, 54, 55, 56, 57, 64, 66, ),
        /* 50 */ array(15, 28, 31, 32, 34, 41, 49, 53, 54, 55, 56, 64, 66, ),
        /* 51 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 52 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 53 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 54 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 55 */ array(15, 31, 32, 34, 49, 53, 54, 55, 56, 64, 66, ),
        /* 56 */ array(31, 32, 34, 49, 55, 56, 64, ),
        /* 57 */ array(31, 32, 34, 49, 55, 56, 64, ),
        /* 58 */ array(31, 32, 34, 49, 55, 56, 64, ),
        /* 59 */ array(15, 31, 32, 34, 49, 64, 66, ),
        /* 60 */ array(15, 31, 32, 34, 49, 64, 66, ),
        /* 61 */ array(15, 31, 32, 34, 49, 64, 66, ),
        /* 62 */ array(31, 32, 34, 49, 64, ),
        /* 63 */ array(31, 32, 34, 49, 64, ),
        /* 64 */ array(28, 31, 32, 34, 49, 64, ),
        /* 65 */ array(31, 32, 34, 49, 64, ),
        /* 66 */ array(31, 32, 34, 49, 64, ),
        /* 67 */ array(31, 32, 34, 49, 64, ),
        /* 68 */ array(31, 32, 34, 49, 64, ),
        /* 69 */ array(31, 32, 34, 49, 64, ),
        /* 70 */ array(31, 32, 34, 49, 64, ),
        /* 71 */ array(31, 32, 34, 49, 64, ),
        /* 72 */ array(31, 32, 34, 49, 64, ),
        /* 73 */ array(31, 32, 34, 49, 64, ),
        /* 74 */ array(31, 32, 34, 49, 64, ),
        /* 75 */ array(31, 32, 34, 49, 64, ),
        /* 76 */ array(31, 32, 34, 49, 64, ),
        /* 77 */ array(1, 23, 24, 25, ),
        /* 78 */ array(1, 23, 24, 25, ),
        /* 79 */ array(1, 23, 24, 25, ),
        /* 80 */ array(1, 23, 24, 25, ),
        /* 81 */ array(1, 23, 24, 25, ),
        /* 82 */ array(1, 23, 24, 25, ),
        /* 83 */ array(1, 23, 24, 25, ),
        /* 84 */ array(1, 23, 24, 25, ),
        /* 85 */ array(1, 23, 24, 25, ),
        /* 86 */ array(1, 23, 24, 25, ),
        /* 87 */ array(1, 23, 24, 25, ),
        /* 88 */ array(1, 23, 24, 25, ),
        /* 89 */ array(1, 23, 24, 25, ),
        /* 90 */ array(1, 23, 24, 25, ),
        /* 91 */ array(1, 23, 24, 25, ),
        /* 92 */ array(1, 23, 24, 25, ),
        /* 93 */ array(1, 23, 24, 25, ),
        /* 94 */ array(1, 23, 24, 25, ),
        /* 95 */ array(1, 23, 24, 25, ),
        /* 96 */ array(1, 23, 24, 25, ),
        /* 97 */ array(1, 23, 24, 25, ),
        /* 98 */ array(1, 23, 24, 25, ),
        /* 99 */ array(1, 23, 24, 25, ),
        /* 100 */ array(15, 28, 66, ),
        /* 101 */ array(55, 56, ),
        /* 102 */ array(),
        /* 103 */ array(),
        /* 104 */ array(),
        /* 105 */ array(),
        /* 106 */ array(),
        /* 107 */ array(),
        /* 108 */ array(),
        /* 109 */ array(),
        /* 110 */ array(),
        /* 111 */ array(),
        /* 112 */ array(),
        /* 113 */ array(),
        /* 114 */ array(),
        /* 115 */ array(),
        /* 116 */ array(),
        /* 117 */ array(),
        /* 118 */ array(),
        /* 119 */ array(),
        /* 120 */ array(),
        /* 121 */ array(),
        /* 122 */ array(),
        /* 123 */ array(),
        /* 124 */ array(3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 57, ),
        /* 125 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 126 */ array(3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 28, ),
        /* 127 */ array(3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 26, ),
        /* 128 */ array(3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 129 */ array(3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 130 */ array(4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 131 */ array(5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 132 */ array(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 133 */ array(7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ),
        /* 134 */ array(58, 59, 60, 61, 62, ),
        /* 135 */ array(17, 18, 19, 20, 21, ),
        /* 136 */ array(22, 28, ),
        /* 137 */ array(6, 65, ),
        /* 138 */ array(22, 28, ),
        /* 139 */ array(20, 21, ),
        /* 140 */ array(22, 28, ),
        /* 141 */ array(28, 42, ),
        /* 142 */ array(13, 41, ),
        /* 143 */ array(22, 52, ),
        /* 144 */ array(55, ),
        /* 145 */ array(28, ),
        /* 146 */ array(28, ),
        /* 147 */ array(38, ),
        /* 148 */ array(28, ),
        /* 149 */ array(28, ),
        /* 150 */ array(28, ),
        /* 151 */ array(28, ),
        /* 152 */ array(28, ),
        /* 153 */ array(28, ),
        /* 154 */ array(28, ),
        /* 155 */ array(28, ),
        /* 156 */ array(28, ),
        /* 157 */ array(33, ),
        /* 158 */ array(28, ),
        /* 159 */ array(63, ),
        /* 160 */ array(28, ),
        /* 161 */ array(28, ),
        /* 162 */ array(13, ),
        /* 163 */ array(22, ),
        /* 164 */ array(65, ),
        /* 165 */ array(28, ),
        /* 166 */ array(22, ),
        /* 167 */ array(28, ),
        /* 168 */ array(28, ),
        /* 169 */ array(28, ),
        /* 170 */ array(28, ),
        /* 171 */ array(28, ),
        /* 172 */ array(28, ),
        /* 173 */ array(28, ),
        /* 174 */ array(66, ),
        /* 175 */ array(28, ),
        /* 176 */ array(28, ),
        /* 177 */ array(28, ),
        /* 178 */ array(6, ),
        /* 179 */ array(28, ),
        /* 180 */ array(28, ),
        /* 181 */ array(28, ),
        /* 182 */ array(28, ),
        /* 183 */ array(28, ),
        /* 184 */ array(28, ),
        /* 185 */ array(28, ),
        /* 186 */ array(28, ),
        /* 187 */ array(28, ),
        /* 188 */ array(33, ),
        /* 189 */ array(28, ),
        /* 190 */ array(57, ),
        /* 191 */ array(22, ),
        /* 192 */ array(28, ),
        /* 193 */ array(28, ),
        /* 194 */ array(28, ),
        /* 195 */ array(28, ),
        /* 196 */ array(28, ),
        /* 197 */ array(28, ),
        /* 198 */ array(),
        /* 199 */ array(),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(),
        /* 210 */ array(),
        /* 211 */ array(),
        /* 212 */ array(),
        /* 213 */ array(),
        /* 214 */ array(),
        /* 215 */ array(),
        /* 216 */ array(),
        /* 217 */ array(),
        /* 218 */ array(),
        /* 219 */ array(),
        /* 220 */ array(),
        /* 221 */ array(),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
);
    static public $yy_default = array(
 /*     0 */   280,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    10 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    20 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    30 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    40 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    50 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    60 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    70 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    80 */   278,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*    90 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*   100 */   372,  372,  280,  280,  280,  280,  280,  280,  280,  280,
 /*   110 */   280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
 /*   120 */   280,  280,  280,  280,  372,  372,  372,  372,  305,  349,
 /*   130 */   350,  351,  353,  348,  361,  352,  372,  334,  372,  354,
 /*   140 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*   150 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*   160 */   372,  372,  372,  372,  372,  372,  345,  372,  372,  372,
 /*   170 */   372,  372,  372,  372,  372,  372,  372,  372,  334,  372,
 /*   180 */   372,  372,  372,  372,  372,  372,  372,  372,  372,  372,
 /*   190 */   372,  342,  372,  372,  372,  372,  372,  372,  302,  281,
 /*   200 */   279,  328,  368,  319,  284,  285,  327,  311,  326,  312,
 /*   210 */   369,  367,  317,  329,  282,  283,  309,  313,  296,  297,
 /*   220 */   365,  295,  293,  294,  298,  299,  335,  304,  303,  301,
 /*   230 */   300,  336,  292,  291,  359,  362,  337,  360,  370,  371,
 /*   240 */   363,  364,  289,  290,  288,  287,  286,  330,  333,  320,
 /*   250 */   341,  346,  318,  315,  316,  321,  340,  338,  324,  323,
 /*   260 */   339,  322,  347,  314,  355,  356,  344,  343,  331,  332,
 /*   270 */   357,  358,  310,  366,  308,  307,  306,  325,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 97;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 278;
    const YYNRULE = 94;
    const YYERRORSYMBOL = 67;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx = -1;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'T_TAG_OPEN',    'T_NOT',         'T_AND',       
  'T_OR',          'T_QUESTION',    'T_COLON',       'T_EQ',        
  'T_NE',          'T_GT',          'T_GE',          'T_LT',        
  'T_LE',          'T_IN',          'T_PLUS',        'T_MINUS',     
  'T_CONCAT',      'T_TIMES',       'T_DIV',         'T_MOD',       
  'T_PIPE',        'T_BITWISE',     'T_FILTER_PIPE',  'T_HTML',      
  'T_COMMENT',     'T_PRINT_OPEN',  'T_PRINT_CLOSE',  'T_EXTENDS',   
  'T_TAG_CLOSE',   'T_INCLUDE',     'T_AUTOESCAPE',  'T_CUSTOM_END',
  'T_CUSTOM_TAG',  'T_AS',          'T_CUSTOM_BLOCK',  'T_SPACEFULL', 
  'T_WITH',        'T_SET',         'T_ASSIGN',      'T_LOAD',      
  'T_FOR',         'T_COMMA',       'T_STEP',        'T_EMPTY',     
  'T_IF',          'T_ELSE',        'T_IFCHANGED',   'T_IFEQUAL',   
  'T_IFNOTEQUAL',  'T_BLOCK',       'T_FILTER',      'T_REGROUP',   
  'T_BY',          'T_TRUE',        'T_FALSE',       'T_STRING',    
  'T_INTL',        'T_RPARENT',     'T_LPARENT',     'T_OBJ',       
  'T_DOT',         'T_CLASS',       'T_BRACKETS_OPEN',  'T_BRACKETS_CLOSE',
  'T_ALPHA',       'T_DOTDOT',      'T_NUMERIC',     'error',       
  'start',         'body',          'code',          'stmts',       
  'expr',          'var_or_string',  'stmt',          'for_stmt',    
  'ifchanged_stmt',  'block_stmt',    'filter_stmt',   'if_stmt',     
  'custom_tag',    'alias',         'ifequal',       'varname',     
  'params',        'regroup',       'string',        'for_def',     
  'filtered_var',  'range',         'numvar',        'fvar_or_string',
  'number',        'varname_args',  'varpart',       'varpart_single',
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= body",
 /*   1 */ "body ::= body code",
 /*   2 */ "body ::=",
 /*   3 */ "code ::= T_TAG_OPEN stmts",
 /*   4 */ "code ::= T_HTML",
 /*   5 */ "code ::= T_COMMENT",
 /*   6 */ "code ::= T_PRINT_OPEN expr T_PRINT_CLOSE",
 /*   7 */ "stmts ::= T_EXTENDS var_or_string T_TAG_CLOSE",
 /*   8 */ "stmts ::= stmt T_TAG_CLOSE",
 /*   9 */ "stmts ::= for_stmt",
 /*  10 */ "stmts ::= ifchanged_stmt",
 /*  11 */ "stmts ::= block_stmt",
 /*  12 */ "stmts ::= filter_stmt",
 /*  13 */ "stmts ::= if_stmt",
 /*  14 */ "stmts ::= T_INCLUDE var_or_string T_TAG_CLOSE",
 /*  15 */ "stmts ::= custom_tag",
 /*  16 */ "stmts ::= alias",
 /*  17 */ "stmts ::= ifequal",
 /*  18 */ "stmts ::= T_AUTOESCAPE varname T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  19 */ "custom_tag ::= T_CUSTOM_TAG T_TAG_CLOSE",
 /*  20 */ "custom_tag ::= T_CUSTOM_TAG T_AS varname T_TAG_CLOSE",
 /*  21 */ "custom_tag ::= T_CUSTOM_TAG params T_TAG_CLOSE",
 /*  22 */ "custom_tag ::= T_CUSTOM_TAG params T_AS varname T_TAG_CLOSE",
 /*  23 */ "custom_tag ::= T_CUSTOM_BLOCK T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  24 */ "custom_tag ::= T_CUSTOM_BLOCK params T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  25 */ "custom_tag ::= T_SPACEFULL T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  26 */ "alias ::= T_WITH varname T_AS varname T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  27 */ "stmt ::= T_SET varname T_ASSIGN expr",
 /*  28 */ "stmt ::= regroup",
 /*  29 */ "stmt ::= T_LOAD string",
 /*  30 */ "for_def ::= T_FOR varname T_IN filtered_var T_TAG_CLOSE",
 /*  31 */ "for_def ::= T_FOR varname T_COMMA varname T_IN filtered_var T_TAG_CLOSE",
 /*  32 */ "for_stmt ::= for_def body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  33 */ "for_stmt ::= T_FOR varname T_IN range T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  34 */ "for_stmt ::= T_FOR varname T_IN range T_STEP numvar T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  35 */ "for_stmt ::= for_def body T_TAG_OPEN T_EMPTY T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  36 */ "if_stmt ::= T_IF expr T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  37 */ "if_stmt ::= T_IF expr T_TAG_CLOSE body T_TAG_OPEN T_ELSE T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  38 */ "ifchanged_stmt ::= T_IFCHANGED T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  39 */ "ifchanged_stmt ::= T_IFCHANGED params T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  40 */ "ifchanged_stmt ::= T_IFCHANGED T_TAG_CLOSE body T_TAG_OPEN T_ELSE T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  41 */ "ifchanged_stmt ::= T_IFCHANGED params T_TAG_CLOSE body T_TAG_OPEN T_ELSE T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  42 */ "ifequal ::= T_IFEQUAL fvar_or_string fvar_or_string T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  43 */ "ifequal ::= T_IFEQUAL fvar_or_string fvar_or_string T_TAG_CLOSE body T_TAG_OPEN T_ELSE T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  44 */ "ifequal ::= T_IFNOTEQUAL fvar_or_string fvar_or_string T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  45 */ "ifequal ::= T_IFNOTEQUAL fvar_or_string fvar_or_string T_TAG_CLOSE body T_TAG_OPEN T_ELSE T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  46 */ "block_stmt ::= T_BLOCK varname T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  47 */ "block_stmt ::= T_BLOCK varname T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END varname T_TAG_CLOSE",
 /*  48 */ "block_stmt ::= T_BLOCK number T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  49 */ "block_stmt ::= T_BLOCK number T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END number T_TAG_CLOSE",
 /*  50 */ "filter_stmt ::= T_FILTER filtered_var T_TAG_CLOSE body T_TAG_OPEN T_CUSTOM_END T_TAG_CLOSE",
 /*  51 */ "regroup ::= T_REGROUP filtered_var T_BY varname T_AS varname",
 /*  52 */ "filtered_var ::= filtered_var T_FILTER_PIPE varname_args",
 /*  53 */ "filtered_var ::= string T_FILTER_PIPE varname_args",
 /*  54 */ "filtered_var ::= varname_args",
 /*  55 */ "varname_args ::= varname T_COLON var_or_string",
 /*  56 */ "varname_args ::= varname",
 /*  57 */ "params ::= params var_or_string",
 /*  58 */ "params ::= params T_COMMA var_or_string",
 /*  59 */ "params ::= var_or_string",
 /*  60 */ "var_or_string ::= varname",
 /*  61 */ "var_or_string ::= number",
 /*  62 */ "var_or_string ::= T_TRUE|T_FALSE",
 /*  63 */ "var_or_string ::= string",
 /*  64 */ "fvar_or_string ::= filtered_var",
 /*  65 */ "fvar_or_string ::= number",
 /*  66 */ "fvar_or_string ::= T_TRUE|T_FALSE",
 /*  67 */ "fvar_or_string ::= string",
 /*  68 */ "string ::= T_STRING",
 /*  69 */ "string ::= T_INTL T_STRING T_RPARENT",
 /*  70 */ "expr ::= expr T_QUESTION expr T_COLON expr",
 /*  71 */ "expr ::= T_NOT expr",
 /*  72 */ "expr ::= expr T_AND expr",
 /*  73 */ "expr ::= expr T_OR expr",
 /*  74 */ "expr ::= expr T_PLUS|T_MINUS|T_CONCAT expr",
 /*  75 */ "expr ::= expr T_EQ|T_NE|T_GT|T_GE|T_LT|T_LE|T_IN expr",
 /*  76 */ "expr ::= expr T_TIMES|T_DIV|T_MOD expr",
 /*  77 */ "expr ::= expr T_BITWISE expr",
 /*  78 */ "expr ::= expr T_PIPE expr",
 /*  79 */ "expr ::= T_LPARENT expr T_RPARENT",
 /*  80 */ "expr ::= fvar_or_string",
 /*  81 */ "varname ::= varpart T_LPARENT T_RPARENT",
 /*  82 */ "varname ::= varpart T_LPARENT params T_RPARENT",
 /*  83 */ "varname ::= varpart",
 /*  84 */ "varpart ::= varpart T_OBJ|T_DOT varpart_single",
 /*  85 */ "varpart ::= varpart T_CLASS varpart_single",
 /*  86 */ "varpart ::= varpart T_BRACKETS_OPEN var_or_string T_BRACKETS_CLOSE",
 /*  87 */ "varpart ::= varpart_single",
 /*  88 */ "varpart_single ::= T_ALPHA|T_BLOCK|T_CUSTOM_TAG|T_CUSTOM_END|T_CUSTOM_BLOCK",
 /*  89 */ "range ::= numvar T_DOTDOT numvar",
 /*  90 */ "numvar ::= number",
 /*  91 */ "numvar ::= varname",
 /*  92 */ "number ::= T_NUMERIC",
 /*  93 */ "number ::= T_MINUS T_NUMERIC",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param Haanga_yyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::$yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new Haanga_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new Haanga_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::$yyTokenName[$iLookAhead] . " => " .
                        self::$yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new Haanga_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::$yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 68, 'rhs' => 1 ),
  array( 'lhs' => 69, 'rhs' => 2 ),
  array( 'lhs' => 69, 'rhs' => 0 ),
  array( 'lhs' => 70, 'rhs' => 2 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 1 ),
  array( 'lhs' => 70, 'rhs' => 3 ),
  array( 'lhs' => 71, 'rhs' => 3 ),
  array( 'lhs' => 71, 'rhs' => 2 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 3 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 1 ),
  array( 'lhs' => 71, 'rhs' => 7 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 4 ),
  array( 'lhs' => 80, 'rhs' => 3 ),
  array( 'lhs' => 80, 'rhs' => 5 ),
  array( 'lhs' => 80, 'rhs' => 6 ),
  array( 'lhs' => 80, 'rhs' => 7 ),
  array( 'lhs' => 80, 'rhs' => 6 ),
  array( 'lhs' => 81, 'rhs' => 9 ),
  array( 'lhs' => 74, 'rhs' => 4 ),
  array( 'lhs' => 74, 'rhs' => 1 ),
  array( 'lhs' => 74, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 7 ),
  array( 'lhs' => 75, 'rhs' => 5 ),
  array( 'lhs' => 75, 'rhs' => 9 ),
  array( 'lhs' => 75, 'rhs' => 11 ),
  array( 'lhs' => 75, 'rhs' => 9 ),
  array( 'lhs' => 79, 'rhs' => 7 ),
  array( 'lhs' => 79, 'rhs' => 11 ),
  array( 'lhs' => 76, 'rhs' => 6 ),
  array( 'lhs' => 76, 'rhs' => 7 ),
  array( 'lhs' => 76, 'rhs' => 10 ),
  array( 'lhs' => 76, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 12 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 12 ),
  array( 'lhs' => 77, 'rhs' => 7 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 77, 'rhs' => 7 ),
  array( 'lhs' => 77, 'rhs' => 8 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 73, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 5 ),
  array( 'lhs' => 72, 'rhs' => 2 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 3 ),
  array( 'lhs' => 72, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 4 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        69 => 8,
        9 => 9,
        10 => 9,
        11 => 9,
        12 => 9,
        13 => 9,
        15 => 9,
        16 => 9,
        17 => 9,
        28 => 9,
        56 => 9,
        68 => 9,
        80 => 9,
        87 => 9,
        88 => 9,
        90 => 9,
        92 => 9,
        14 => 14,
        18 => 18,
        19 => 19,
        20 => 20,
        21 => 21,
        22 => 22,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        29 => 29,
        30 => 30,
        31 => 31,
        32 => 32,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        49 => 47,
        48 => 48,
        50 => 50,
        51 => 51,
        52 => 52,
        58 => 52,
        53 => 53,
        54 => 54,
        59 => 54,
        55 => 55,
        57 => 57,
        60 => 60,
        91 => 60,
        61 => 61,
        65 => 61,
        62 => 62,
        66 => 62,
        63 => 63,
        67 => 63,
        64 => 64,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 72,
        74 => 72,
        76 => 72,
        75 => 75,
        77 => 77,
        78 => 78,
        79 => 79,
        81 => 81,
        82 => 82,
        83 => 83,
        84 => 84,
        85 => 85,
        86 => 86,
        89 => 89,
        93 => 93,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 81 "lib/Haanga/Compiler/Parser.y"
    function yy_r0(){ $this->body = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1765 "lib/Haanga/Compiler/Parser.php"
#line 83 "lib/Haanga/Compiler/Parser.y"
    function yy_r1(){ $this->_retvalue=$this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1768 "lib/Haanga/Compiler/Parser.php"
#line 84 "lib/Haanga/Compiler/Parser.y"
    function yy_r2(){ $this->_retvalue = array();     }
#line 1771 "lib/Haanga/Compiler/Parser.php"
#line 87 "lib/Haanga/Compiler/Parser.y"
    function yy_r3(){ if (count($this->yystack[$this->yyidx + 0]->minor)) $this->yystack[$this->yyidx + 0]->minor['line'] = $this->lex->getLine();  $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1774 "lib/Haanga/Compiler/Parser.php"
#line 89 "lib/Haanga/Compiler/Parser.y"
    function yy_r4(){
    $this->_retvalue = array('operation' => 'html', 'html' => $this->yystack[$this->yyidx + 0]->minor, 'line' => $this->lex->getLine() ); 
    }
#line 1779 "lib/Haanga/Compiler/Parser.php"
#line 93 "lib/Haanga/Compiler/Parser.y"
    function yy_r5(){
    $this->yystack[$this->yyidx + 0]->minor=rtrim($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = array('operation' => 'comment', 'comment' => $this->yystack[$this->yyidx + 0]->minor); 
    }
#line 1784 "lib/Haanga/Compiler/Parser.php"
#line 97 "lib/Haanga/Compiler/Parser.y"
    function yy_r6(){
    $this->_retvalue = array('operation' => 'print_var', 'expr' => $this->yystack[$this->yyidx + -1]->minor, 'line' => $this->lex->getLine() ); 
    }
#line 1789 "lib/Haanga/Compiler/Parser.php"
#line 101 "lib/Haanga/Compiler/Parser.y"
    function yy_r7(){ $this->_retvalue = array('operation' => 'base', $this->yystack[$this->yyidx + -1]->minor);     }
#line 1792 "lib/Haanga/Compiler/Parser.php"
#line 102 "lib/Haanga/Compiler/Parser.y"
    function yy_r8(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 1795 "lib/Haanga/Compiler/Parser.php"
#line 103 "lib/Haanga/Compiler/Parser.y"
    function yy_r9(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1798 "lib/Haanga/Compiler/Parser.php"
#line 108 "lib/Haanga/Compiler/Parser.y"
    function yy_r14(){ $this->_retvalue = array('operation' => 'include', $this->yystack[$this->yyidx + -1]->minor);     }
#line 1801 "lib/Haanga/Compiler/Parser.php"
#line 112 "lib/Haanga/Compiler/Parser.y"
    function yy_r18(){ 
    $this->yystack[$this->yyidx + -5]->minor = strtolower($this->yystack[$this->yyidx + -5]->minor);
    if ($this->yystack[$this->yyidx + -5]->minor != 'on' && $this->yystack[$this->yyidx + -5]->minor != 'off') {
        $this->Error("Invalid autoescape param (".$this->yystack[$this->yyidx + -5]->minor."), it must be on or off");
    }
    if ($this->yystack[$this->yyidx + -1]->minor != "endautoescape") {
        $this->Error("Invalid close tag ".$this->yystack[$this->yyidx + -1]->minor.", it must be endautoescape");
    }
    $this->_retvalue = array('operation' => 'autoescape', 'value' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 1813 "lib/Haanga/Compiler/Parser.php"
#line 126 "lib/Haanga/Compiler/Parser.y"
    function yy_r19(){
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -1]->minor, 'list'=>array()); 
    }
#line 1818 "lib/Haanga/Compiler/Parser.php"
#line 129 "lib/Haanga/Compiler/Parser.y"
    function yy_r20(){
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -3]->minor, 'as' => $this->yystack[$this->yyidx + -1]->minor, 'list'=>array()); 
    }
#line 1823 "lib/Haanga/Compiler/Parser.php"
#line 132 "lib/Haanga/Compiler/Parser.y"
    function yy_r21(){ 
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -2]->minor, 'list' => $this->yystack[$this->yyidx + -1]->minor); 
    }
#line 1828 "lib/Haanga/Compiler/Parser.php"
#line 135 "lib/Haanga/Compiler/Parser.y"
    function yy_r22(){
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -4]->minor, 'as' => $this->yystack[$this->yyidx + -1]->minor, 'list' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 1833 "lib/Haanga/Compiler/Parser.php"
#line 140 "lib/Haanga/Compiler/Parser.y"
    function yy_r23(){
    if ('end'.$this->yystack[$this->yyidx + -5]->minor != $this->yystack[$this->yyidx + -1]->minor) { 
        $this->error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor); 
    } 
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor, 'list' => array());
    }
#line 1841 "lib/Haanga/Compiler/Parser.php"
#line 146 "lib/Haanga/Compiler/Parser.y"
    function yy_r24(){
    if ('end'.$this->yystack[$this->yyidx + -6]->minor != $this->yystack[$this->yyidx + -1]->minor) { 
        $this->error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor); 
    } 
    $this->_retvalue = array('operation' => 'custom_tag', 'name' => $this->yystack[$this->yyidx + -6]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor, 'list' => $this->yystack[$this->yyidx + -5]->minor);
    }
#line 1849 "lib/Haanga/Compiler/Parser.php"
#line 154 "lib/Haanga/Compiler/Parser.y"
    function yy_r25(){
    if ('endspacefull' != $this->yystack[$this->yyidx + -1]->minor) {
        $this->error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor);
    } 
    $this->_retvalue = array('operation' => 'spacefull', 'body' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 1857 "lib/Haanga/Compiler/Parser.php"
#line 162 "lib/Haanga/Compiler/Parser.y"
    function yy_r26(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endwith") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endwith");
    }
    $this->_retvalue = array('operation' => 'alias', 'var' => $this->yystack[$this->yyidx + -7]->minor, 'as' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 1865 "lib/Haanga/Compiler/Parser.php"
#line 170 "lib/Haanga/Compiler/Parser.y"
    function yy_r27(){ $this->_retvalue = array('operation' => 'set', 'var' => $this->yystack[$this->yyidx + -2]->minor,'expr' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 1868 "lib/Haanga/Compiler/Parser.php"
#line 172 "lib/Haanga/Compiler/Parser.y"
    function yy_r29(){
    if (is_file(dirname($this->file) . '/' . $this->yystack[$this->yyidx + 0]->minor)) {
        $this->yystack[$this->yyidx + 0]->minor = dirname($this->file) . '/' . $this->yystack[$this->yyidx + 0]->minor;
    } else if (is_file(getcwd() . '/' . $this->yystack[$this->yyidx + 0]->minor)) {
        $this->yystack[$this->yyidx + 0]->minor = getcwd() . '/' . $this->yystack[$this->yyidx + 0]->minor;
    }
    if (!is_file($this->yystack[$this->yyidx + 0]->minor) || !Haanga_Compiler::getOption('enable_load')) {
        $this->error($this->yystack[$this->yyidx + 0]->minor." is not a valid file"); 
    } 
    require_once $this->yystack[$this->yyidx + 0]->minor;
    }
#line 1881 "lib/Haanga/Compiler/Parser.php"
#line 186 "lib/Haanga/Compiler/Parser.y"
    function yy_r30(){
    $var = $this->compiler->get_context($this->yystack[$this->yyidx + -1]->minor[0]);
    if (is_array($var) || $var instanceof Iterator) {
        /* let's check if it is an object or array */
        $this->compiler->set_context($this->yystack[$this->yyidx + -3]->minor, current($var));
    }
    $this->_retvalue = array('operation' => 'loop', 'variable' => $this->yystack[$this->yyidx + -3]->minor, 'index' => NULL, 'array' => $this->yystack[$this->yyidx + -1]->minor);
    }
#line 1891 "lib/Haanga/Compiler/Parser.php"
#line 194 "lib/Haanga/Compiler/Parser.y"
    function yy_r31(){
    $var = $this->compiler->get_context($this->yystack[$this->yyidx + -1]->minor[0]);
    if (is_array($var) || $var instanceof Iterator) {
        /* let's check if it is an object or array */
        $this->compiler->set_context($this->yystack[$this->yyidx + -3]->minor, current($var));
    }
    $this->_retvalue = array('operation' => 'loop', 'variable' => $this->yystack[$this->yyidx + -3]->minor, 'index' => $this->yystack[$this->yyidx + -5]->minor, 'array' => $this->yystack[$this->yyidx + -1]->minor);

    }
#line 1902 "lib/Haanga/Compiler/Parser.php"
#line 204 "lib/Haanga/Compiler/Parser.y"
    function yy_r32(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endfor") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endfor");
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue['body'] = $this->yystack[$this->yyidx + -3]->minor;
    }
#line 1911 "lib/Haanga/Compiler/Parser.php"
#line 212 "lib/Haanga/Compiler/Parser.y"
    function yy_r33(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endfor") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endfor");
    }
    $this->_retvalue = array('operation' => 'loop', 'variable' => $this->yystack[$this->yyidx + -7]->minor, 'range' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor, 'variable' => $this->yystack[$this->yyidx + -7]->minor, 'step' => 1);
    }
#line 1919 "lib/Haanga/Compiler/Parser.php"
#line 219 "lib/Haanga/Compiler/Parser.y"
    function yy_r34(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endfor") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endfor");
    }
    $this->_retvalue = array('operation' => 'loop', 'variable' => $this->yystack[$this->yyidx + -9]->minor, 'range' => $this->yystack[$this->yyidx + -7]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor, 'variable' => $this->yystack[$this->yyidx + -9]->minor, 'step' => $this->yystack[$this->yyidx + -5]->minor);
    }
#line 1927 "lib/Haanga/Compiler/Parser.php"
#line 226 "lib/Haanga/Compiler/Parser.y"
    function yy_r35(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endfor") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endfor");
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -8]->minor;
    $this->_retvalue['body']  = $this->yystack[$this->yyidx + -7]->minor;
    $this->_retvalue['empty'] = $this->yystack[$this->yyidx + -3]->minor;
    }
#line 1937 "lib/Haanga/Compiler/Parser.php"
#line 235 "lib/Haanga/Compiler/Parser.y"
    function yy_r36(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endif") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endif");
    }
    $this->_retvalue = array('operation' => 'if', 'expr' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 1945 "lib/Haanga/Compiler/Parser.php"
#line 241 "lib/Haanga/Compiler/Parser.y"
    function yy_r37(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endif") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endif");
    }
    $this->_retvalue = array('operation' => 'if', 'expr' => $this->yystack[$this->yyidx + -9]->minor, 'body' => $this->yystack[$this->yyidx + -7]->minor, 'else' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 1953 "lib/Haanga/Compiler/Parser.php"
#line 249 "lib/Haanga/Compiler/Parser.y"
    function yy_r38(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endifchanged") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifchanged");
    }
    $this->_retvalue = array('operation' => 'ifchanged', 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 1961 "lib/Haanga/Compiler/Parser.php"
#line 256 "lib/Haanga/Compiler/Parser.y"
    function yy_r39(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endifchanged") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifchanged");
    }
    $this->_retvalue = array('operation' => 'ifchanged', 'body' => $this->yystack[$this->yyidx + -3]->minor, 'check' => $this->yystack[$this->yyidx + -5]->minor);
    }
#line 1969 "lib/Haanga/Compiler/Parser.php"
#line 262 "lib/Haanga/Compiler/Parser.y"
    function yy_r40(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endifchanged") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifchanged");
    }
    $this->_retvalue = array('operation' => 'ifchanged', 'body' => $this->yystack[$this->yyidx + -7]->minor, 'else' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 1977 "lib/Haanga/Compiler/Parser.php"
#line 269 "lib/Haanga/Compiler/Parser.y"
    function yy_r41(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endifchanged") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifchanged");
    }
    $this->_retvalue = array('operation' => 'ifchanged', 'body' => $this->yystack[$this->yyidx + -7]->minor, 'check' => $this->yystack[$this->yyidx + -9]->minor, 'else' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 1985 "lib/Haanga/Compiler/Parser.php"
#line 277 "lib/Haanga/Compiler/Parser.y"
    function yy_r42(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endifequal") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifequal");
    }
    $this->_retvalue = array('operation' => 'ifequal', 'cmp' => '==', 1 => $this->yystack[$this->yyidx + -6]->minor, 2 => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 1993 "lib/Haanga/Compiler/Parser.php"
#line 283 "lib/Haanga/Compiler/Parser.y"
    function yy_r43(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endifequal") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifequal");
    }
    $this->_retvalue = array('operation' => 'ifequal', 'cmp' => '==', 1 => $this->yystack[$this->yyidx + -10]->minor, 2 => $this->yystack[$this->yyidx + -9]->minor, 'body' => $this->yystack[$this->yyidx + -7]->minor, 'else' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 2001 "lib/Haanga/Compiler/Parser.php"
#line 289 "lib/Haanga/Compiler/Parser.y"
    function yy_r44(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endifnotequal") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifnotequal");
    }
    $this->_retvalue = array('operation' => 'ifequal', 'cmp' => '!=', 1 => $this->yystack[$this->yyidx + -6]->minor, 2 => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 2009 "lib/Haanga/Compiler/Parser.php"
#line 295 "lib/Haanga/Compiler/Parser.y"
    function yy_r45(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endifnotequal") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endifnotequal");
    }
    $this->_retvalue = array('operation' => 'ifequal', 'cmp' => '!=', 1 => $this->yystack[$this->yyidx + -10]->minor, 2 => $this->yystack[$this->yyidx + -9]->minor, 'body' => $this->yystack[$this->yyidx + -7]->minor, 'else' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 2017 "lib/Haanga/Compiler/Parser.php"
#line 303 "lib/Haanga/Compiler/Parser.y"
    function yy_r46(){ 
    if ($this->yystack[$this->yyidx + -1]->minor != "endblock") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endblock");
    }
    $this->_retvalue = array('operation' => 'block', 'name' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 2025 "lib/Haanga/Compiler/Parser.php"
#line 310 "lib/Haanga/Compiler/Parser.y"
    function yy_r47(){
    if ($this->yystack[$this->yyidx + -2]->minor != "endblock") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -2]->minor.", expecting endblock");
    }
    $this->_retvalue = array('operation' => 'block', 'name' => $this->yystack[$this->yyidx + -6]->minor, 'body' => $this->yystack[$this->yyidx + -4]->minor); 
    }
#line 2033 "lib/Haanga/Compiler/Parser.php"
#line 317 "lib/Haanga/Compiler/Parser.y"
    function yy_r48(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endblock") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endblock");
    }
    $this->_retvalue = array('operation' => 'block', 'name' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor); 
    }
#line 2041 "lib/Haanga/Compiler/Parser.php"
#line 332 "lib/Haanga/Compiler/Parser.y"
    function yy_r50(){
    if ($this->yystack[$this->yyidx + -1]->minor != "endfilter") {
        $this->Error("Unexpected ".$this->yystack[$this->yyidx + -1]->minor.", expecting endfilter");
    }
    $this->_retvalue = array('operation' => 'filter', 'functions' => $this->yystack[$this->yyidx + -5]->minor, 'body' => $this->yystack[$this->yyidx + -3]->minor);
    }
#line 2049 "lib/Haanga/Compiler/Parser.php"
#line 340 "lib/Haanga/Compiler/Parser.y"
    function yy_r51(){ $this->_retvalue=array('operation' => 'regroup', 'array' => $this->yystack[$this->yyidx + -4]->minor, 'row' => $this->yystack[$this->yyidx + -2]->minor, 'as' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2052 "lib/Haanga/Compiler/Parser.php"
#line 343 "lib/Haanga/Compiler/Parser.y"
    function yy_r52(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2055 "lib/Haanga/Compiler/Parser.php"
#line 344 "lib/Haanga/Compiler/Parser.y"
    function yy_r53(){ $this->_retvalue = array(array('string' => $this->yystack[$this->yyidx + -2]->minor)); $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2058 "lib/Haanga/Compiler/Parser.php"
#line 345 "lib/Haanga/Compiler/Parser.y"
    function yy_r54(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);     }
#line 2061 "lib/Haanga/Compiler/Parser.php"
#line 347 "lib/Haanga/Compiler/Parser.y"
    function yy_r55(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, 'args'=>array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2064 "lib/Haanga/Compiler/Parser.php"
#line 351 "lib/Haanga/Compiler/Parser.y"
    function yy_r57(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2067 "lib/Haanga/Compiler/Parser.php"
#line 357 "lib/Haanga/Compiler/Parser.y"
    function yy_r60(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2070 "lib/Haanga/Compiler/Parser.php"
#line 358 "lib/Haanga/Compiler/Parser.y"
    function yy_r61(){ $this->_retvalue = array('number' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2073 "lib/Haanga/Compiler/Parser.php"
#line 359 "lib/Haanga/Compiler/Parser.y"
    function yy_r62(){ $this->_retvalue = trim(@$this->yystack[$this->yyidx + 0]->minor);     }
#line 2076 "lib/Haanga/Compiler/Parser.php"
#line 360 "lib/Haanga/Compiler/Parser.y"
    function yy_r63(){ $this->_retvalue = array('string' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2079 "lib/Haanga/Compiler/Parser.php"
#line 363 "lib/Haanga/Compiler/Parser.y"
    function yy_r64(){
    $this->_retvalue = array('var_filter' => $this->yystack[$this->yyidx + 0]->minor); 
    }
#line 2084 "lib/Haanga/Compiler/Parser.php"
#line 375 "lib/Haanga/Compiler/Parser.y"
    function yy_r70(){
    $this->_retvalue = array('expr_cond' => $this->yystack[$this->yyidx + -4]->minor, 'true' => $this->yystack[$this->yyidx + -2]->minor, 'false' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2089 "lib/Haanga/Compiler/Parser.php"
#line 378 "lib/Haanga/Compiler/Parser.y"
    function yy_r71(){ $this->_retvalue = array('op_expr' => 'not', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2092 "lib/Haanga/Compiler/Parser.php"
#line 379 "lib/Haanga/Compiler/Parser.y"
    function yy_r72(){ $this->_retvalue = array('op_expr' => @$this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2095 "lib/Haanga/Compiler/Parser.php"
#line 382 "lib/Haanga/Compiler/Parser.y"
    function yy_r75(){ $this->_retvalue = array('op_expr' => trim(@$this->yystack[$this->yyidx + -1]->minor), $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2098 "lib/Haanga/Compiler/Parser.php"
#line 384 "lib/Haanga/Compiler/Parser.y"
    function yy_r77(){ $this->_retvalue = array('op_expr' => 'expr', array('op_expr' => @$this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor));     }
#line 2101 "lib/Haanga/Compiler/Parser.php"
#line 385 "lib/Haanga/Compiler/Parser.y"
    function yy_r78(){ $this->_retvalue = array('op_expr' => 'expr', array('op_expr' => '|', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor));     }
#line 2104 "lib/Haanga/Compiler/Parser.php"
#line 386 "lib/Haanga/Compiler/Parser.y"
    function yy_r79(){ $this->_retvalue = array('op_expr' => 'expr', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2107 "lib/Haanga/Compiler/Parser.php"
#line 391 "lib/Haanga/Compiler/Parser.y"
    function yy_r81(){
    $this->_retvalue = hexec($this->yystack[$this->yyidx + -2]->minor)->getArray();
    }
#line 2112 "lib/Haanga/Compiler/Parser.php"
#line 395 "lib/Haanga/Compiler/Parser.y"
    function yy_r82(){
    $tmp  = hcode();
    $args = array_merge(array($this->yystack[$this->yyidx + -3]->minor),  $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue =  call_user_func_array(array($tmp, 'exec'), $args);
    }
#line 2119 "lib/Haanga/Compiler/Parser.php"
#line 401 "lib/Haanga/Compiler/Parser.y"
    function yy_r83(){ $this->_retvalue = current($this->compiler->generate_variable_name($this->yystack[$this->yyidx + 0]->minor, false));     }
#line 2122 "lib/Haanga/Compiler/Parser.php"
#line 403 "lib/Haanga/Compiler/Parser.y"
    function yy_r84(){ 
    if (!is_array($this->yystack[$this->yyidx + -2]->minor)) { $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor); } 
    else { $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor; }  $this->_retvalue[]=array('object' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2128 "lib/Haanga/Compiler/Parser.php"
#line 408 "lib/Haanga/Compiler/Parser.y"
    function yy_r85(){ 
    if (!is_array($this->yystack[$this->yyidx + -2]->minor)) { $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor); } 
    else { $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor; }  $this->_retvalue[]=array('class' => '$'.$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2134 "lib/Haanga/Compiler/Parser.php"
#line 413 "lib/Haanga/Compiler/Parser.y"
    function yy_r86(){
    if (!is_array($this->yystack[$this->yyidx + -3]->minor)) { $this->_retvalue = array($this->yystack[$this->yyidx + -3]->minor); } 
    else { $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor; }  $this->_retvalue[]=$this->yystack[$this->yyidx + -1]->minor;
    }
#line 2140 "lib/Haanga/Compiler/Parser.php"
#line 422 "lib/Haanga/Compiler/Parser.y"
    function yy_r89(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2143 "lib/Haanga/Compiler/Parser.php"
#line 428 "lib/Haanga/Compiler/Parser.y"
    function yy_r93(){ $this->_retvalue = -1 * ($this->yystack[$this->yyidx + 0]->minor);     }
#line 2146 "lib/Haanga/Compiler/Parser.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //Haanga_yyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new Haanga_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 72 "lib/Haanga/Compiler/Parser.y"

    $expect = array();
    foreach ($this->yy_get_expected_tokens($yymajor) as $token) {
        $expect[] = self::$yyTokenName[$token];
    }
    $this->Error('Unexpected ' . $this->tokenName($yymajor) . '(' . $TOKEN. ')');
#line 2266 "lib/Haanga/Compiler/Parser.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 57 "lib/Haanga/Compiler/Parser.y"

#line 2287 "lib/Haanga/Compiler/Parser.php"
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int   $yymajor      the token number
     * @param mixed $yytokenvalue the token value
     * @param mixed ...           any extra arguments that should be passed to handlers
     *
     * @return void
     */
    function doParse($yymajor, $yytokenvalue)
    {
//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new Haanga_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(
                self::$yyTraceFILE,
                "%sInput %s\n",
                self::$yyTracePrompt,
                self::$yyTokenName[$yymajor]
            );
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL
                && !$this->yy_is_expected_token($yymajor)
            ) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(
                        self::$yyTraceFILE,
                        "%sSyntax Error!\n",
                        self::$yyTracePrompt
                    );
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ) {
                        if (self::$yyTraceFILE) {
                            fprintf(
                                self::$yyTraceFILE,
                                "%sDiscard input token %s\n",
                                self::$yyTracePrompt,
                                self::$yyTokenName[$yymajor]
                            );
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0
                            && $yymx != self::YYERRORSYMBOL
                            && ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                        ) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
