/*!
 * The Final Countdown  (http://hilios.github.io/jQuery.countdown/)
 * Copyright (c) 2014 Edson Hilios
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(factory){"use strict";"function"==typeof define&&define.amd?define(["jquery"],factory):factory(jQuery)}((function($){"use strict";var PRECISION=100,instances=[],matchers=[];function parseDateString(dateString){if(dateString instanceof Date)return dateString;if(String(dateString).match(matchers))return String(dateString).match(/^[0-9]*$/)&&(dateString=Number(dateString)),String(dateString).match(/\-/)&&(dateString=String(dateString).replace(/\-/g,"/")),new Date(dateString);throw new Error("Couldn't cast `"+dateString+"` to a date object.")}matchers.push(/^[0-9]*$/.source),matchers.push(/([0-9]{1,2}\/){2}[0-9]{4}( [0-9]{1,2}(:[0-9]{2}){2})?/.source),matchers.push(/[0-9]{4}([\/\-][0-9]{1,2}){2}( [0-9]{1,2}(:[0-9]{2}){2})?/.source),matchers=new RegExp(matchers.join("|"));var DIRECTIVE_KEY_MAP={Y:"years",m:"months",w:"weeks",d:"days",D:"totalDays",H:"hours",M:"minutes",S:"seconds"};function strftime(offsetObject){return function(format){var directives=format.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);if(directives)for(var i=0,len=directives.length;i<len;++i){var directive=directives[i].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/),regexp=new RegExp(directive[0]),modifier=directive[1]||"",plural=directive[3]||"",value=null;directive=directive[2],DIRECTIVE_KEY_MAP.hasOwnProperty(directive)&&(value=DIRECTIVE_KEY_MAP[directive],value=Number(offsetObject[value])),null!==value&&("!"===modifier&&(value=pluralize(plural,value)),""===modifier&&value<10&&(value="0"+value.toString()),format=format.replace(regexp,value.toString()))}return format=format.replace(/%%/,"%")}}function pluralize(format,count){var plural="s",singular="";return format&&(1===(format=format.replace(/(:|;|\s)/gi,"").split(/\,/)).length?plural=format[0]:(singular=format[0],plural=format[1])),1===Math.abs(count)?singular:plural}var Countdown=function(el,finalDate,callback){this.el=el,this.$el=$(el),this.interval=null,this.offset={},this.instanceNumber=instances.length,instances.push(this),this.$el.data("countdown-instance",this.instanceNumber),callback&&(this.$el.on("update.countdown",callback),this.$el.on("stoped.countdown",callback),this.$el.on("finish.countdown",callback)),this.setFinalDate(finalDate),this.start()};$.extend(Countdown.prototype,{start:function(){null!==this.interval&&clearInterval(this.interval);var self=this;this.update(),this.interval=setInterval((function(){self.update.call(self)}),100)},stop:function(){clearInterval(this.interval),this.interval=null,this.dispatchEvent("stoped")},pause:function(){this.stop.call(this)},resume:function(){this.start.call(this)},remove:function(){this.stop(),instances[this.instanceNumber]=null,delete this.$el.data().countdownInstance},setFinalDate:function(value){this.finalDate=parseDateString(value)},update:function(){0!==this.$el.closest("html").length?(this.totalSecsLeft=this.finalDate.getTime()-(new Date).getTime(),this.totalSecsLeft=Math.ceil(this.totalSecsLeft/1e3),this.totalSecsLeft=this.totalSecsLeft<0?0:this.totalSecsLeft,this.offset={seconds:this.totalSecsLeft%60,minutes:Math.floor(this.totalSecsLeft/60)%60,hours:Math.floor(this.totalSecsLeft/60/60)%24,days:Math.floor(this.totalSecsLeft/60/60/24)%7,totalDays:Math.floor(this.totalSecsLeft/60/60/24),weeks:Math.floor(this.totalSecsLeft/60/60/24/7),months:Math.floor(this.totalSecsLeft/60/60/24/30),years:Math.floor(this.totalSecsLeft/60/60/24/365)},0===this.totalSecsLeft?(this.stop(),this.dispatchEvent("finish")):this.dispatchEvent("update")):this.remove()},dispatchEvent:function(eventName){var event=$.Event(eventName+".countdown");event.finalDate=this.finalDate,event.offset=$.extend({},this.offset),event.strftime=strftime(this.offset),this.$el.trigger(event)}}),$.fn.countdown=function(){var argumentsArray=Array.prototype.slice.call(arguments,0);return this.each((function(){var instanceNumber=$(this).data("countdown-instance");if(void 0!==instanceNumber){var instance=instances[instanceNumber],method=argumentsArray[0];Countdown.prototype.hasOwnProperty(method)?instance[method].apply(instance,argumentsArray.slice(1)):null===String(method).match(/^[$A-Z_][0-9A-Z_$]*$/i)?(instance.setFinalDate.call(instance,method),instance.start()):$.error("Method %s does not exist on jQuery.countdown".replace(/\%s/gi,method))}else new Countdown(this,argumentsArray[0],argumentsArray[1])}))}}));